/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.sip;

import gov.nist.javax.sip.header.From;

import javax.sip.RequestEvent;
import javax.sip.address.SipURI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.xml.parsers.ParserConfigurationException;

import jp.ac.naka.ec.EventDispatcher;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.sip.pidf.PIDFParserImpl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

/**
 * @author Takashi Kasuya
 * 
 */
class MessageDelegate implements MethodDelegate {
	private static Log logger = LogFactory.getLog(MessageDelegate.class);
	PIDFParserImpl parser = PIDFParserImpl.getInatance();
	private static SipCore core;
	private static EntityContainer container;
	
	public MessageDelegate() throws ParserConfigurationException, SAXException {
		core = SipCore.getInstance();
		container = EntityContainerImpl.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.sip.MethodDelegate#forward(javax.sip.RequestEvent)
	 */
	public boolean forward(RequestEvent evt) {
		Request req = evt.getRequest();

		byte[] content = req.getRawContent();
		ToHeader to = (ToHeader) req.getHeader(ToHeader.NAME);
		SipURI toUri = (SipURI) to.getAddress().getURI();
		// ContactHeader from =
		// (ContactHeader)req.getHeader(ContactHeader.NAME);
		FromHeader from = (FromHeader) req.getHeader(From.NAME);
		SipURI fromUri = (SipURI) from.getAddress().getURI();
		ContentTypeHeader content_type = (ContentTypeHeader) req
				.getHeader(ContentTypeHeader.NAME);
		try {
			Entity source = new EntityImpl(fromUri);
			source.setLocal(false);
			AbstractEntity target = (AbstractEntity)container.getEntity(toUri.toString());
			if (target == null) 
				throw new NullPointerException(toUri + " is null!");
			String message = new String(content, "UTF-8");
			EntityEvent e = null;
			if (content_type.getContentType().equals("text")
					&& content_type.getContentSubType().equals("plain")) {
				e = new EntityEvent(message, target, source);
			} else {
				throw new IllegalArgumentException(
						"Can not handle ContentType :" + content_type);
			}
			
			// 200 OK
			core.sendResponse(Response.OK, req);
			target.handleEvent(e);
		} catch (Exception e) {
			logger.warn("Error occures while processing SIP Message :", e);
			return false;
		}
		return true;
	}
}
