/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.LogWriter;
import gov.nist.core.net.AddressResolver;
import gov.nist.core.net.NetworkLayer;
import gov.nist.javax.sip.EventScanner;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.NistSipMessageFactoryImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.stack.DefaultRouter;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerLog;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.ProviderDoesNotExistException;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TransportNotSupportedException;
import javax.sip.address.Router;

public class SipStackImpl
extends SIPTransactionStack
implements SipStack {
    EventScanner eventScanner;
    private Hashtable listeningPoints;
    private LinkedList sipProviders;
    boolean reEntrantListener;
    SipListener sipListener;
    boolean deliverTerminatedEventForAck = false;
    boolean deliverUnsolicitedNotify = false;

    protected SipStackImpl() {
        NistSipMessageFactoryImpl msgFactory = new NistSipMessageFactoryImpl(this);
        super.setMessageFactory(msgFactory);
        this.eventScanner = new EventScanner(this);
        this.listeningPoints = new Hashtable();
        this.sipProviders = new LinkedList();
    }

    private void reInitialize() {
        super.reInit();
        this.eventScanner = new EventScanner(this);
        this.listeningPoints = new Hashtable();
        this.sipProviders = new LinkedList();
        this.sipListener = null;
    }

    boolean isAutomaticDialogSupportEnabled() {
        return this.isAutomaticDialogSupportEnabled;
    }

    public SipStackImpl(Properties configurationProperties) throws PeerUnavailableException {
        this();
        String stunAddr;
        String readTimeout;
        String transactionTableSize;
        String threadPoolSize;
        String maxConnections;
        String extensionMethods;
        String address = configurationProperties.getProperty("javax.sip.IP_ADDRESS");
        try {
            if (address != null) {
                super.setHostAddress(address);
            }
        }
        catch (UnknownHostException ex) {
            throw new PeerUnavailableException("bad address " + address);
        }
        String name = configurationProperties.getProperty("javax.sip.STACK_NAME");
        if (name == null) {
            throw new PeerUnavailableException("stack name is missing");
        }
        super.setStackName(name);
        this.logWriter = new LogWriter(configurationProperties);
        this.serverLog = new ServerLog(this, configurationProperties);
        this.defaultRouter = new DefaultRouter(this, this.outboundProxy);
        String routerPath = configurationProperties.getProperty("javax.sip.ROUTER_PATH");
        if (routerPath == null) {
            routerPath = "gov.nist.javax.sip.stack.DefaultRouter";
        }
        String outboundProxy = configurationProperties.getProperty("javax.sip.OUTBOUND_PROXY");
        try {
            Class<?> routerClass = Class.forName(routerPath);
            Class[] constructorArgs = new Class[]{SipStack.class, String.class};
            Constructor<?> cons = routerClass.getConstructor(constructorArgs);
            Object[] args = new Object[]{this, outboundProxy};
            Router router = (Router)cons.newInstance(args);
            super.setRouter(router);
        }
        catch (InvocationTargetException ex1) {
            this.getLogWriter().logError("could not instantiate router -- invocation target problem", (Exception)ex1.getCause());
            throw new PeerUnavailableException("Cound not instantiate router - check constructor", ex1);
        }
        catch (Exception ex) {
            this.getLogWriter().logError("could not instantiate router", (Exception)ex.getCause());
            throw new PeerUnavailableException("Could not instantiate router", ex);
        }
        String useRouterForAll = configurationProperties.getProperty("javax.sip.USE_ROUTER_FOR_ALL_URIS");
        this.useRouterForAll = true;
        if (useRouterForAll != null) {
            this.useRouterForAll = "true".equalsIgnoreCase(useRouterForAll);
        }
        if ((extensionMethods = configurationProperties.getProperty("javax.sip.EXTENSION_METHODS")) != null) {
            StringTokenizer st = new StringTokenizer(extensionMethods);
            while (st.hasMoreTokens()) {
                String em = st.nextToken(":");
                if (em.equalsIgnoreCase("BYE") || em.equalsIgnoreCase("INVITE") || em.equalsIgnoreCase("SUBSCRIBE") || em.equalsIgnoreCase("NOTIFY") || em.equalsIgnoreCase("ACK") || em.equalsIgnoreCase("OPTIONS")) {
                    throw new PeerUnavailableException("Bad extension method " + em);
                }
                this.addExtensionMethod(em);
            }
        }
        this.isAutomaticDialogSupportEnabled = configurationProperties.getProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT", "on").equalsIgnoreCase("on");
        this.deliverTerminatedEventForAck = configurationProperties.getProperty("gov.nist.javax.sip.DELIVER_TERMINATED_EVENT_FOR_ACK", "false").equalsIgnoreCase("true");
        this.deliverUnsolicitedNotify = configurationProperties.getProperty("gov.nist.javax.sip.DELIVER_UNSOLICITED_NOTIFY", "false").equalsIgnoreCase("true");
        String forkedSubscriptions = configurationProperties.getProperty("javax.sip.FORKABLE_EVENTS");
        if (forkedSubscriptions != null) {
            StringTokenizer st = new StringTokenizer(forkedSubscriptions);
            while (st.hasMoreTokens()) {
                String nextEvent = st.nextToken();
                this.forkedEvents.add(nextEvent);
            }
        }
        String NETWORK_LAYER_KEY = "gov.nist.javax.sip.NETWORK_LAYER";
        if (configurationProperties.containsKey("gov.nist.javax.sip.NETWORK_LAYER")) {
            String path = configurationProperties.getProperty("gov.nist.javax.sip.NETWORK_LAYER");
            try {
                Class<?> clazz = Class.forName(path);
                Constructor<?> c = clazz.getConstructor(new Class[0]);
                this.networkLayer = (NetworkLayer)c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new PeerUnavailableException("can't find or instantiate NetworkLayer implementation: " + path);
            }
        }
        String ADDRESS_RESOLVER_KEY = "gov.nist.javax.sip.ADDRESS_RESOLVER";
        if (configurationProperties.containsKey("gov.nist.javax.sip.ADDRESS_RESOLVER")) {
            String path = configurationProperties.getProperty("gov.nist.javax.sip.ADDRESS_RESOLVER");
            try {
                Class<?> clazz = Class.forName(path);
                Constructor<?> c = clazz.getConstructor(new Class[0]);
                this.addressResolver = (AddressResolver)c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new PeerUnavailableException("can't find or instantiate AddressResolver implementation: " + path);
            }
        }
        if ((maxConnections = configurationProperties.getProperty("gov.nist.javax.sip.MAX_CONNECTIONS")) != null) {
            try {
                this.maxConnections = new Integer(maxConnections);
            }
            catch (NumberFormatException ex) {
                System.out.println("max connections - bad value " + ex.getMessage());
            }
        }
        if ((threadPoolSize = configurationProperties.getProperty("gov.nist.javax.sip.THREAD_POOL_SIZE")) != null) {
            try {
                this.threadPoolSize = new Integer(threadPoolSize);
            }
            catch (NumberFormatException ex) {
                System.out.println("thread pool size - bad value " + ex.getMessage());
            }
        }
        if ((transactionTableSize = configurationProperties.getProperty("gov.nist.javax.sip.MAX_SERVER_TRANSACTIONS")) != null) {
            try {
                this.serverTransactionTableHighwaterMark = new Integer(transactionTableSize);
                this.serverTransactionTableLowaterMark = this.serverTransactionTableHighwaterMark * 80 / 100;
            }
            catch (NumberFormatException ex) {
                System.out.println("transaction table size - bad value " + ex.getMessage());
            }
        }
        this.cacheServerConnections = true;
        String flag = configurationProperties.getProperty("gov.nist.javax.sip.CACHE_SERVER_CONNECTIONS");
        if (flag != null && "false".equalsIgnoreCase(flag.trim())) {
            this.cacheServerConnections = false;
        }
        this.cacheClientConnections = true;
        String cacheflag = configurationProperties.getProperty("gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS");
        if (cacheflag != null && "false".equalsIgnoreCase(cacheflag.trim())) {
            this.cacheClientConnections = false;
        }
        if ((readTimeout = configurationProperties.getProperty("gov.nist.javax.sip.READ_TIMEOUT")) != null) {
            try {
                int rt = Integer.parseInt(readTimeout);
                if (rt >= 100) {
                    this.readTimeout = rt;
                } else {
                    System.out.println("Value too low " + readTimeout);
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("Bad read timeout " + readTimeout);
            }
        }
        if ((stunAddr = configurationProperties.getProperty("gov.nist.javax.sip.STUN_SERVER")) != null) {
            this.logWriter.logWarning("Ignoring obsolete property gov.nist.javax.sip.STUN_SERVER");
        }
        String maxMsgSize = configurationProperties.getProperty("gov.nist.javax.sip.MAX_MESSAGE_SIZE");
        try {
            if (maxMsgSize != null) {
                this.maxMessageSize = new Integer(maxMsgSize);
                if (this.maxMessageSize < 4096) {
                    this.maxMessageSize = 4096;
                }
            } else {
                this.maxMessageSize = 0;
            }
        }
        catch (NumberFormatException ex) {
            System.out.println("maxMessageSize - bad value " + ex.getMessage());
        }
        String rel = configurationProperties.getProperty("gov.nist.javax.sip.REENTRANT_LISTENER");
        this.reEntrantListener = rel != null && "true".equalsIgnoreCase(rel);
        this.non2XXAckPassedToListener = Boolean.valueOf(configurationProperties.getProperty("gov.nist.javax.sip.PASS_INVITE_NON_2XX_ACK_TO_LISTENER", "false"));
        this.generateTimeStampHeader = Boolean.valueOf(configurationProperties.getProperty("gov.nist.javax.sip.AUTO_GENERATE_TIMESTAMP", "false"));
    }

    public synchronized ListeningPoint createListeningPoint(String address, int port, String transport) throws TransportNotSupportedException, InvalidArgumentException {
        String key;
        ListeningPointImpl lip;
        this.getLogWriter().logDebug("createListeningPoint : address = " + address + " port = " + port + " transport = " + transport);
        if (address == null) {
            throw new NullPointerException("Address for listening point is null!");
        }
        if (transport == null) {
            throw new NullPointerException("null transport");
        }
        if (port <= 0) {
            throw new InvalidArgumentException("bad port");
        }
        if (!(transport.equalsIgnoreCase("UDP") || transport.equalsIgnoreCase("TLS") || transport.equalsIgnoreCase("TCP"))) {
            throw new TransportNotSupportedException("bad transport " + transport);
        }
        if (!this.isAlive()) {
            this.toExit = false;
            this.reInitialize();
        }
        if ((lip = (ListeningPointImpl)this.listeningPoints.get(key = ListeningPointImpl.makeKey(address, port, transport))) != null) {
            return lip;
        }
        MessageProcessor messageProcessor = null;
        try {
            InetAddress inetAddr = InetAddress.getByName(address);
            messageProcessor = this.createMessageProcessor(inetAddr, port, transport);
            if (this.isLoggingEnabled()) {
                this.getLogWriter().logDebug("Created Message Processor: " + address + " port = " + port + " transport = " + transport);
            }
            lip = new ListeningPointImpl(this, port, transport);
            lip.messageProcessor = messageProcessor;
            messageProcessor.setListeningPoint(lip);
            this.listeningPoints.put(key, lip);
            messageProcessor.start();
            return lip;
        }
        catch (IOException ex) {
            this.listeningPoints.remove(key);
            this.removeMessageProcessor(messageProcessor);
            this.getLogWriter().logError("Invalid argument address = " + address + " port = " + port + " transport = " + transport);
            throw new InvalidArgumentException(ex.getMessage(), ex);
        }
    }

    public SipProvider createSipProvider(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint");
        }
        if (this.getLogWriter().isLoggingEnabled()) {
            this.getLogWriter().logDebug("createSipProvider: " + listeningPoint);
        }
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)listeningPoint;
        if (listeningPointImpl.sipProvider != null) {
            throw new ObjectInUseException("Provider already attached!");
        }
        SipProviderImpl provider = new SipProviderImpl(this);
        provider.setListeningPoint(listeningPointImpl);
        listeningPointImpl.sipProvider = provider;
        this.sipProviders.add(provider);
        return provider;
    }

    public void deleteListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint arg");
        }
        ListeningPointImpl lip = (ListeningPointImpl)listeningPoint;
        super.removeMessageProcessor(lip.messageProcessor);
        String key = lip.getKey();
        this.listeningPoints.remove(key);
    }

    public void deleteSipProvider(SipProvider sipProvider) throws ObjectInUseException {
        if (sipProvider == null) {
            throw new NullPointerException("null provider arg");
        }
        SipProviderImpl sipProviderImpl = (SipProviderImpl)sipProvider;
        if (sipProviderImpl.sipListener != null) {
            throw new ObjectInUseException("SipProvider still has an associated SipListener!");
        }
        sipProviderImpl.removeListeningPoints();
        sipProviderImpl.stop();
        this.sipProviders.remove(sipProvider);
        if (this.sipProviders.isEmpty()) {
            this.stopStack();
        }
    }

    public String getIPAddress() {
        return super.getHostAddress();
    }

    public Iterator getListeningPoints() {
        return this.listeningPoints.values().iterator();
    }

    public boolean isRetransmissionFilterActive() {
        return true;
    }

    public Iterator getSipProviders() {
        return this.sipProviders.iterator();
    }

    public String getStackName() {
        return this.stackName;
    }

    public void finalize() {
        this.stopStack();
    }

    public ListeningPoint createListeningPoint(int port, String transport) throws TransportNotSupportedException, InvalidArgumentException {
        if (this.stackAddress == null) {
            throw new NullPointerException("Stack does not have a default IP Address!");
        }
        return this.createListeningPoint(this.stackAddress, port, transport);
    }

    public void stop() {
        if (this.getLogWriter().isLoggingEnabled()) {
            this.getLogWriter().logDebug("stopStack -- stoppping the stack");
        }
        this.stopStack();
        this.sipProviders = new LinkedList();
        this.listeningPoints = new Hashtable();
        this.eventScanner.forceStop();
        this.eventScanner = null;
    }

    public void start() throws ProviderDoesNotExistException, SipException {
        if (this.eventScanner == null) {
            this.eventScanner = new EventScanner(this);
        }
    }

    protected SipListener getSipListener() {
        return this.sipListener;
    }
}

