/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.sip.address.SipURI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityConfigParser {
    public static Log logger = LogFactory.getLog(EntityConfigParser.class);

    public Entity[] parse(final String config_file) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException e) throws SAXException {
                    logger.error((Object)("Error while parsing " + config_file), (Throwable)e);
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    logger.error((Object)("Error while parsing " + config_file), (Throwable)e);
                }

                public void warning(SAXParseException e) throws SAXException {
                    logger.error((Object)("Error while parsing " + config_file), (Throwable)e);
                }
            });
            Document doc = db.parse(new File(config_file));
            Element root = doc.getDocumentElement();
            NodeList entities = root.getElementsByTagName("entity");
            ArrayList<Object> list = new ArrayList();
            list = EntityConfigParser.parseEntity(entities);
            Entity[] a = new Entity[list.size()];
            return list.toArray(a);
        }
        catch (Exception e) {
            logger.error((Object)"Error while initiating Entity class", (Throwable)e);
            return new Entity[0];
        }
    }

    private static ArrayList<Entity> parseEntity(NodeList entities) throws IOException, ParseException {
        String host = String.valueOf(EntityContainerImpl.getIpAddress(EntityContainerImpl.getHostName())) + ":" + SipCore.PORT;
        ArrayList<Entity> list = new ArrayList<Entity>();
        int i = 0;
        while (i < entities.getLength()) {
            block14: {
                Entity instance;
                Element entity = (Element)entities.item(i);
                String id = entity.getAttribute("id");
                String cls = entity.getAttribute("class");
                Node temp = entity.getElementsByTagName("type").item(0);
                String type = "SENSOR";
                if (temp != null) {
                    type = temp.getFirstChild().getNodeValue();
                }
                String description = "";
                temp = entity.getElementsByTagName("description").item(0);
                if (temp != null) {
                    description = temp.getFirstChild().getNodeValue();
                }
                String[] keywords = null;
                temp = entity.getElementsByTagName("keywords").item(0);
                if (temp != null) {
                    String str = temp.getFirstChild().getNodeValue();
                    StringTokenizer stToken = new StringTokenizer(str, ", ");
                    keywords = new String[stToken.countTokens()];
                    int num = 0;
                    while (stToken.hasMoreTokens()) {
                        keywords[num++] = stToken.nextToken();
                    }
                }
                SipURI uri = EntityImpl.createSipURI(id, host);
                try {
                    Class<?> clazz = Class.forName(cls);
                    clazz.getConstructors();
                    instance = (Entity)clazz.newInstance();
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)("Could not found class :" + cls), (Throwable)e);
                    break block14;
                }
                catch (Exception e) {
                    logger.error((Object)("Error while initiating class :" + cls), (Throwable)e);
                    break block14;
                }
                instance.setURI(uri);
                instance.setName(id);
                instance.setDescrpition(description);
                instance.setEntityType(EntityType.valueOf(type));
                boolean cfr_ignored_0 = instance instanceof AbstractEntity;
                if (keywords != null) {
                    String[] stringArray = keywords;
                    int n = keywords.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String keyword = stringArray[n2];
                        instance.addKeyword(keyword);
                        ++n2;
                    }
                }
                if ((temp = entity.getElementsByTagName("location").item(0)) != null) {
                    String location = ((Element)temp).getAttribute("name");
                    temp = ((Element)temp).getElementsByTagName("latitude").item(0);
                    String lat = "";
                    String lon = "";
                    if (temp != null) {
                        lat = temp.getFirstChild().getNodeValue();
                        temp = temp.getNextSibling();
                        do {
                            if (temp.getNodeType() == 3 || !temp.getNodeName().equals("longitude")) continue;
                            lon = temp.getFirstChild().getNodeValue();
                            break;
                        } while ((temp = temp.getNextSibling()) != null);
                    }
                    if (!lat.equals("") && !lon.equals("")) {
                        instance.setLocation(new Location(location, lat, lon));
                    }
                }
                list.add(instance);
            }
            ++i;
        }
        return list;
    }

    public static void main(String[] args) {
        Entity[] entities;
        EntityConfigParser parser = new EntityConfigParser();
        Entity[] entityArray = entities = parser.parse("config/entities.xml");
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            System.out.println(entity);
            ++n2;
        }
    }
}

