/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.media;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Manager;
import javax.media.MediaException;
import javax.media.MediaLocator;
import javax.media.NoDataSinkException;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.protocol.DataSource;
import javax.sdp.Media;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SessionDescription;
import javax.swing.JFrame;
import jp.ac.naka.ec.media.MediaListener;
import jp.ac.naka.ec.media.MediaReceiveEvent;

public class AudioReceiver {
    MediaLocator locator;
    Processor player;
    Processor processor;
    SessionDescription sdp;
    WaitingListener listener;
    private List<MediaListener> listeners = new ArrayList<MediaListener>();
    private boolean storing = false;
    DataSink sink;

    public void receiveMedia(SessionDescription sdp) throws MediaException, SdpException {
        try {
            int port = 0;
            Vector mls = sdp.getMediaDescriptions(true);
            for (MediaDescription md : mls) {
                Media media = md.getMedia();
                if (!media.getMediaType().equals("audio")) continue;
                port = media.getMediaPort();
                break;
            }
            String url = "rtp://:" + port + "/audio";
            this.locator = new MediaLocator(url);
            this.createPlayer();
            this.player.prefetch();
            this.player.start();
            this.listener.waitForEvent(600);
            MediaReceiveEvent evt = new MediaReceiveEvent(this, MediaReceiveEvent.EventType.RECEIVE);
            this.dispatchEvent(evt);
            this.sdp = sdp;
        }
        catch (IOException e) {
            this.player.close();
            throw new MediaException(e.getMessage());
        }
    }

    public void receiveMedia(int port) throws MediaException {
        try {
            String url = "rtp://:" + port + "/audio";
            this.locator = new MediaLocator(url);
            this.createPlayer();
            this.player.prefetch();
            this.player.start();
            MediaReceiveEvent evt = new MediaReceiveEvent(this, MediaReceiveEvent.EventType.RECEIVE);
            this.dispatchEvent(evt);
        }
        catch (IOException e) {
            this.player.close();
            throw new MediaException(e.getMessage());
        }
    }

    public boolean isPlaying() {
        return this.player.getState() == 600;
    }

    public void stop() {
        this.player.close();
        try {
            this.stopStore();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MediaReceiveEvent evt = new MediaReceiveEvent(this, MediaReceiveEvent.EventType.TERMINATE);
        this.dispatchEvent(evt);
    }

    public Component getControlPanelComponent() {
        if (this.player != null) {
            return this.player.getControlPanelComponent();
        }
        throw new NullPointerException("Player\u304c\u4f5c\u3089\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    private void createPlayer() throws IOException, MediaException {
        if (this.locator == null) {
            throw new NullPointerException("Locator is null");
        }
        DataSource dataSource = Manager.createDataSource((MediaLocator)this.locator);
        this.player = Manager.createProcessor((DataSource)dataSource);
        this.listener = new WaitingListener();
        this.player.addControllerListener((ControllerListener)this.listener);
        this.player.configure();
        this.listener.waitForEvent(180);
        this.player.setContentDescriptor(null);
        this.player.realize();
        this.listener.waitForEvent(300);
    }

    public void addMediaListener(MediaListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeMediaListener(MediaListener listener) {
        return this.listeners.remove(listener);
    }

    private void dispatchEvent(MediaReceiveEvent e) {
        for (MediaListener listener : this.listeners) {
            switch (e.type) {
                case RECEIVE: {
                    listener.receiveMedia(e);
                    break;
                }
                case TERMINATE: {
                    listener.terminateMedia(e);
                }
            }
        }
    }

    public void store(String path) throws NoDataSinkException, NotRealizedError, SecurityException, IOException {
        if (!this.isPlaying() && this.storing) {
            return;
        }
        MediaLocator dest = new MediaLocator(path);
        this.sink = Manager.createDataSink((DataSource)this.processor.getDataOutput(), (MediaLocator)dest);
        this.sink.open();
        this.sink.start();
        this.storing = true;
    }

    public void stopStore() throws IOException {
        if (!this.storing) {
            return;
        }
        this.sink.stop();
        this.sink.close();
    }

    public static void main(String[] args) {
        AudioReceiver receiver = new AudioReceiver();
        try {
            receiver.receiveMedia(22224);
            JFrame jf = new JFrame();
            jf.add(receiver.getControlPanelComponent());
            jf.setVisible(true);
            jf.pack();
            jf.setDefaultCloseOperation(3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class WaitingListener
    implements ControllerListener {
        Thread th;
        int state;
        int previous;

        WaitingListener() {
        }

        public void waitForEvent(final int state) {
            this.state = state;
            this.th = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (WaitingListener.this.previous < state) {
                                this.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            this.th.start();
            try {
                this.th.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent evt) {
            System.out.println(evt.toString());
            Player p = (Player)evt.getSourceController();
            this.previous = p.getState();
            if (this.th == null) {
                return;
            }
            if (p.getState() >= this.state) {
                Thread thread = this.th;
                synchronized (thread) {
                    this.th.notifyAll();
                }
            }
        }
    }
}

