/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.address.SipURI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import jp.ac.naka.ec.EntityCollaborator;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.sip.InviteCallback;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class InviteDelegate
implements MethodDelegate {
    private static Log logger = LogFactory.getLog(InviteDelegate.class);
    private static SipCore core;
    private static SdpFactory factory;
    private static EntityContainer container;
    private Callback callback = new Callback();

    static {
        factory = SdpFactory.getInstance();
    }

    public InviteDelegate() {
        core = SipCore.getInstance();
        container = EntityContainerImpl.getInstance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean forward(RequestEvent evt) {
        Request req = evt.getRequest();
        ContentTypeHeader type = (ContentTypeHeader)req.getHeader("Content-Type");
        FromHeader from = (FromHeader)req.getHeader("From");
        if (type.getContentType().equals("application") && type.getContentSubType().equals("sdp")) {
            Entity target;
            SipURI sourceURI;
            SessionDescription sdp;
            block12: {
                byte[] raw;
                block11: {
                    try {
                        raw = req.getRawContent();
                        if (!this.isMidRequest(evt)) break block11;
                        core.sendResponse(500, evt, from.getAddress().getURI().toString());
                        return false;
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Error while processing SDP.", (Throwable)e);
                        try {
                            core.sendResponse(500, evt, from.getAddress().getURI().toString());
                            return false;
                        }
                        catch (Exception e1) {
                            logger.warn((Object)"Cannot send a error Response.", (Throwable)e);
                        }
                        return false;
                    }
                }
                sdp = null;
                if (raw != null) {
                    String sdp_str = new String(raw, "UTF-8");
                    sdp = factory.createSessionDescription(sdp_str);
                }
                ToHeader to = (ToHeader)req.getHeader("To");
                SipURI targetURI = (SipURI)to.getAddress().getURI();
                sourceURI = (SipURI)from.getAddress().getURI();
                target = container.getEntity(targetURI.toString());
                if (target == null) {
                    String user = targetURI.getUser();
                    Entity[] result = EntityCollaborator.getInstance().searchEntities(user);
                    if (result.length != 0) {
                        target = result[0];
                    }
                }
                if (target != null) break block12;
                core.sendResponse(404, req);
                return false;
            }
            EntityImpl source = new EntityImpl(sourceURI);
            source.setLocal(false);
            core.sendResponse(100, evt, sourceURI.toString());
            EntityEvent e = new EntityEvent(sdp, (EntityListener)target, (Entity)source);
            e.setRequest(req);
            if (((AbstractEntity)target).getCallback() == null) {
                ((AbstractEntity)target).setCallback(this.callback);
            }
            ((AbstractEntity)target).handleEvent(e);
            return true;
        }
        logger.warn((Object)("Unsuported Content-Type: +" + type.toString()));
        return false;
    }

    private boolean isMidRequest(RequestEvent evt) {
        ServerTransaction st = evt.getServerTransaction();
        return st != null;
    }

    public class Callback
    implements InviteCallback {
        public void receiveAnswer(SessionDescription sdp, EntityEvent evt) {
            if (sdp == null) {
                try {
                    core.sendResponse(486, evt.getRequest());
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Request req = evt.getRequest();
            Entity source = (Entity)evt.getTarget();
            Entity target = (Entity)evt.getSource();
            core.sendResponse(sdp, req, target.getURI(), source.getURI());
        }
    }
}

