/*
 * Decompiled with CFR 0.152.
 */
package ow.dht;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class ByteArray
implements Serializable {
    private final byte[] barray;
    private final int hashCode;

    public ByteArray(byte[] bytes) {
        this.barray = bytes;
        int h = 0;
        for (int i = 0; i < this.barray.length; ++i) {
            h ^= this.barray[i] << i % 4 * 8;
        }
        this.hashCode = h;
    }

    public byte[] getBytes() {
        return this.barray;
    }

    public static ByteArray valueOf(String str, String encoding) throws UnsupportedEncodingException {
        return new ByteArray(str.getBytes(encoding));
    }

    public ByteArray hashWithSHA1() {
        String algName = "SHA1";
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algName);
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        byte[] hashed = md.digest(this.barray);
        return new ByteArray(hashed);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            ByteArray other = (ByteArray)o;
            if (this.barray.length != other.barray.length) {
                return false;
            }
            for (int i = 0; i < this.barray.length; ++i) {
                if (this.barray[i] == other.barray[i]) continue;
                return false;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("0x");
        for (int i = 0; i < this.barray.length; ++i) {
            int b = this.barray[i] & 0xFF;
            if (b < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(b));
        }
        return sb.toString();
    }
}

