/*
 * Decompiled with CFR 0.152.
 */
package ow.dht;

import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Set;
import ow.dht.ByteArray;
import ow.dht.DHTConfiguration;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.MessagingAddress;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DHT<V extends Serializable> {
    public MessagingAddress joinOverlay(String var1, int var2) throws UnknownHostException;

    public MessagingAddress joinOverlay(String var1) throws UnknownHostException;

    public void clearRoutingTable();

    public void clearDHTState();

    public Set<ValueInfo<V>> put(ID var1, V var2, long var3) throws Exception;

    public Set<ValueInfo<V>> put(ID var1, V var2, long var3, ByteArray var5) throws Exception;

    public Set<ValueInfo<V>> get(ID var1);

    public ValueInfo<V> remove(ID var1, V var2, ByteArray var3);

    public ValueInfo<V> remove(ID var1, ID var2, ByteArray var3);

    public Set<ValueInfo<V>> remove(ID var1, ByteArray var2);

    public void stop();

    public void suspend();

    public void resume();

    public Set<ID> getLocalKeys();

    public Set<ValueInfo<V>> getLocalValues(ID var1);

    public Set<ID> getGlobalKeys();

    public Set<ValueInfo<V>> getGlobalValues(ID var1);

    public RoutingService getRoutingService();

    public DHTConfiguration getConfiguration();

    public RoutingAlgorithmConfiguration getRoutingAlgorithmConfiguration();

    public IDAddressPair getSelfIDAddressPair();

    public void setStatCollectorAddress(String var1, int var2) throws UnknownHostException;

    public String getLastKeyString();

    public RoutingResult getLastRoutingResult();

    public String getRoutingTableString();
}

