/*
 * Decompiled with CFR 0.152.
 */
package ow.dht;

import java.io.Serializable;
import ow.dht.ByteArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueInfo<V extends Serializable>
implements Serializable {
    private final V value;
    private long ttl;
    private final ByteArray secret;

    public ValueInfo(V value, long ttl, ByteArray secret) {
        this.value = value;
        this.ttl = ttl;
        this.secret = secret;
    }

    public V getValue() {
        return this.value;
    }

    public long setTTL(long ttl) {
        long old = this.ttl;
        this.ttl = ttl;
        return old;
    }

    public long getTTL() {
        return this.ttl;
    }

    public ByteArray getSecret() {
        return this.secret;
    }

    public int hashCode() {
        int h = this.value.hashCode();
        if (this.secret != null) {
            h ^= this.secret.hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            ValueInfo other = (ValueInfo)o;
            if (!this.value.equals(other.value)) {
                return false;
            }
            if (this.secret != null ? !this.secret.equals(other.secret) : other.secret != null) {
                return false;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(this.value);
        sb.append(",");
        sb.append(this.ttl / 1024L);
        sb.append(",");
        sb.append(this.secret);
        sb.append("}");
        return sb.toString();
    }
}

