/*
 * Decompiled with CFR 0.152.
 */
package ow.dht.impl;

import java.io.File;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.DHTConfiguration;
import ow.dht.ValueInfo;
import ow.directory.DirectoryFactory;
import ow.directory.DirectoryProvider;
import ow.directory.expiration.ExpiringDupDirectory;
import ow.directory.expiration.ExpiringValue;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.MessagingAddress;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CHTImpl<V extends Serializable>
implements DHT<V> {
    static final Logger logger = Logger.getLogger("dht");
    private static final String GLOBAL_DB_NAME = "global";
    private DHTConfiguration config;
    private RoutingAlgorithmConfiguration algoConfig;
    private IDAddressPair selfIDAddressPair;
    private ExpiringDupDirectory<ID, ValueInfo<V>> globalDir;
    private ID lastKey = null;
    private RoutingResult lastRoutingResult;

    public static String getName() {
        return "CHT";
    }

    public CHTImpl(DHTConfiguration config, ID selfID) throws Exception {
        this.init(config, selfID);
    }

    public CHTImpl(short applicationID, short applicationVersion, DHTConfiguration config, ID selfID) throws Exception {
        this.init(config, selfID);
    }

    public CHTImpl(DHTConfiguration config, RoutingService routingSvc) throws Exception {
        this.init(config, routingSvc != null ? routingSvc.getSelfIDAddressPair().getID() : null);
    }

    private void init(DHTConfiguration config, ID selfID) throws Exception {
        this.config = config;
        this.algoConfig = new RoutingAlgorithmConfiguration();
        this.selfIDAddressPair = selfID != null ? new IDAddressPair(selfID, null) : new IDAddressPair(ID.getRandomID(20), null);
        File workingDirFile = new File(config.getWorkingDirectory());
        workingDirFile.mkdirs();
        DirectoryProvider dirProvider = DirectoryFactory.getProvider(config.getDirectoryType());
        this.globalDir = dirProvider.openExpiringDupDirectory(ID.class, config.getValueClass(), config.getWorkingDirectory(), GLOBAL_DB_NAME, config.getDefaultTTL(), config.getDoExpire() ? config.getExpireCheckInterval() : -1L);
        IDAddressPair[] r = new IDAddressPair[]{this.selfIDAddressPair};
        this.lastRoutingResult = new RoutingResult(r, r);
    }

    @Override
    public MessagingAddress joinOverlay(String hostAndPort, int defaultPort) throws UnknownHostException {
        return this.joinOverlay();
    }

    @Override
    public MessagingAddress joinOverlay(String hostAndPort) throws UnknownHostException {
        return this.joinOverlay();
    }

    private MessagingAddress joinOverlay() {
        this.lastKey = this.selfIDAddressPair.getID();
        return null;
    }

    @Override
    public void clearRoutingTable() {
        this.lastKey = null;
    }

    @Override
    public void clearDHTState() {
    }

    public Set<ValueInfo<V>> put(ID key, V value) throws Exception {
        return this.put(key, value, this.config.getDefaultTTL(), null);
    }

    public Set<ValueInfo<V>> put(ID key, V value, ByteArray hashedSecret) throws Exception {
        return this.put(key, value, this.config.getDefaultTTL(), hashedSecret);
    }

    @Override
    public Set<ValueInfo<V>> put(ID key, V value, long ttl) throws Exception {
        return this.put(key, value, ttl, null);
    }

    @Override
    public Set<ValueInfo<V>> put(ID key, V value, long ttl, ByteArray hashedSecret) throws Exception {
        Set<ValueInfo<V>> existedValue = this.globalDir.get(key);
        this.globalDir.put(key, new ValueInfo<V>(value, ttl, hashedSecret), ttl);
        this.lastKey = key;
        return existedValue;
    }

    @Override
    public Set<ValueInfo<V>> get(ID key) {
        Set<ExpiringValue<ValueInfo<V>>> expValues = null;
        try {
            expValues = this.globalDir.getExpiringValue(key);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "An Exception thrown during getting.", e);
        }
        HashSet<ValueInfo<V>> results = new HashSet<ValueInfo<V>>();
        if (expValues != null) {
            for (ExpiringValue<ValueInfo<V>> entry : expValues) {
                ValueInfo<V> v = entry.getValue();
                long ttl = entry.getExpiringTime() - System.currentTimeMillis();
                if (ttl < 0L) {
                    ttl = 0L;
                }
                v.setTTL(ttl);
                results.add(v);
            }
        }
        this.lastKey = key;
        return results;
    }

    @Override
    public ValueInfo<V> remove(ID key, V value, ByteArray hashedSecret) {
        ValueInfo<V> result = null;
        try {
            result = this.globalDir.remove(key, new ValueInfo<V>(value, 0L, hashedSecret));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "An Exception thrown during removing.", e);
        }
        return result;
    }

    @Override
    public ValueInfo<V> remove(ID key, ID valueHash, ByteArray hashedSecret) {
        Set<ValueInfo<V>> s = this.removeInternally(key, valueHash, hashedSecret);
        ValueInfo ret = null;
        if (s != null && !s.isEmpty()) {
            Object[] array = s.toArray();
            ret = (ValueInfo)array[0];
        }
        return ret;
    }

    @Override
    public Set<ValueInfo<V>> remove(ID key, ByteArray hashedSecret) {
        return this.removeInternally(key, null, hashedSecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ValueInfo<V>> removeInternally(ID key, ID valueHash, ByteArray hashedSecret) {
        HashSet<ValueInfo<V>> existedValues = new HashSet<ValueInfo<V>>();
        CHTImpl cHTImpl = this;
        synchronized (cHTImpl) {
            try {
                Set<ExpiringValue<ValueInfo<V>>> expValues = this.globalDir.getExpiringValue(key);
                for (ExpiringValue<ValueInfo<V>> entry : expValues) {
                    ValueInfo<V> v = entry.getValue();
                    ID h = ID.getSHA1BasedID(v.getValue().toString().getBytes(this.config.getValueEncoding()));
                    if (valueHash != null && !h.equals(valueHash) || !hashedSecret.equals(v.getSecret())) continue;
                    this.globalDir.remove(key, v);
                    v.setTTL(entry.getExpiringTime() - System.currentTimeMillis());
                    existedValues.add(v);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "An Exception thrown during getting.", e);
            }
        }
        this.lastKey = key;
        return existedValues;
    }

    @Override
    public void stop() {
    }

    @Override
    public void suspend() {
    }

    @Override
    public void resume() {
    }

    @Override
    public Set<ID> getLocalKeys() {
        return this.globalDir.keySet();
    }

    @Override
    public Set<ValueInfo<V>> getLocalValues(ID key) {
        return this.getValuesInternally(key);
    }

    @Override
    public Set<ID> getGlobalKeys() {
        return this.globalDir.keySet();
    }

    @Override
    public Set<ValueInfo<V>> getGlobalValues(ID key) {
        return this.getValuesInternally(key);
    }

    private Set<ValueInfo<V>> getValuesInternally(ID key) {
        Set<ExpiringValue<ValueInfo<V>>> expiringValues = null;
        try {
            expiringValues = this.globalDir.getExpiringValue(key);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "An Exception thrown when retrieve from the globalDir.", e);
        }
        HashSet<ValueInfo<V>> ret = new HashSet<ValueInfo<V>>();
        for (ExpiringValue<ValueInfo<V>> entry : expiringValues) {
            ValueInfo<V> v = entry.getValue();
            long ttl = entry.getExpiringTime() - System.currentTimeMillis();
            if (ttl < 0L) {
                ttl = 0L;
            }
            v.setTTL(ttl);
            ret.add(v);
        }
        return ret;
    }

    @Override
    public RoutingService getRoutingService() {
        return null;
    }

    @Override
    public DHTConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public RoutingAlgorithmConfiguration getRoutingAlgorithmConfiguration() {
        return this.algoConfig;
    }

    @Override
    public IDAddressPair getSelfIDAddressPair() {
        return this.selfIDAddressPair;
    }

    @Override
    public void setStatCollectorAddress(String host, int port) throws UnknownHostException {
    }

    @Override
    public String getLastKeyString() {
        if (this.lastKey == null) {
            return "null";
        }
        return this.lastKey.toString();
    }

    @Override
    public RoutingResult getLastRoutingResult() {
        return this.lastRoutingResult;
    }

    @Override
    public String getRoutingTableString() {
        return "";
    }
}

