/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.expiration;

import java.io.Serializable;
import java.util.Set;
import ow.directory.Directory;
import ow.directory.expiration.AbstractExpiringDirectory;
import ow.directory.expiration.ExpiringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiringDirectory<K, V>
extends AbstractExpiringDirectory<K, V>
implements Directory<K, V>,
Serializable {
    private Directory<K, ExpiringValue<V>> internalDirectory;

    public ExpiringDirectory(Directory<K, ExpiringValue<V>> dir, long expirationTime, long checkInterval) {
        super(dir, expirationTime, checkInterval);
        this.internalDirectory = dir;
    }

    public V put(K key, V value, long ttl) throws Exception {
        ExpiringValue<V> entry = new ExpiringValue<V>(value, ttl);
        entry = this.internalDirectory.put(key, entry);
        V ret = null;
        if (entry != null) {
            ret = entry.getValue();
        }
        return ret;
    }

    @Override
    public V put(K key, V value) throws Exception {
        return this.put(key, value, this.defaultTTL);
    }

    private V getAndRemove(K key, boolean remove) throws Exception {
        ExpiringValue<V> entry = this.getAndRemoveExpiringValue(key, remove);
        V ret = null;
        if (entry != null) {
            ret = entry.getValue();
        }
        return ret;
    }

    private ExpiringValue<V> getAndRemoveExpiringValue(K key, boolean remove) throws Exception {
        ExpiringValue<V> entry = remove ? this.internalDirectory.remove(key) : this.internalDirectory.get(key);
        return entry;
    }

    @Override
    public V get(K key) throws Exception {
        return this.getAndRemove(key, false);
    }

    public ExpiringValue<V> getExpiringValue(K key) throws Exception {
        return this.getAndRemoveExpiringValue(key, false);
    }

    @Override
    public V remove(K key) throws Exception {
        return this.getAndRemove(key, true);
    }

    @Override
    public Set<K> keySet() {
        return this.internalDirectory.keySet();
    }

    @Override
    public void clear() {
        this.internalDirectory.clear();
    }

    @Override
    public void close() {
        super.stopExpiringDaemon();
        this.internalDirectory.close();
    }
}

