/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public final class Tag {
    private static volatile int lastNumber = 0;
    private final int number;
    private final String name;
    private boolean toBeReportedToStatCollector;
    private final Color color;
    private static final Map<Integer, Color> colorTable = new HashMap<Integer, Color>();
    private static final Map<Integer, Tag> tagTable = new HashMap<Integer, Tag>();
    private static final Map<Integer, String> stringTable = new HashMap<Integer, String>();
    public static final Tag PUNCH_HOLE_REQ = new Tag(0, "PUNCH_HOLE_REQ", false, Color.GRAY);
    public static final Tag PUNCH_HOLE_REP = new Tag("PUNCH_HOLE_REP", false, Color.GRAY);
    public static final Tag PING = new Tag("PING", true, Color.GRAY);
    public static final Tag ACK = new Tag("ACK", true, Color.GRAY);
    public static final Tag ITE_ROUTE_NONE = new Tag("ROUTE_NONE", true, Color.BLACK);
    public static final Tag ITE_ROUTE_INVOKE = new Tag("ROUTE_INVOKE", true, Color.BLACK);
    public static final Tag ITE_ROUTE_JOIN = new Tag("ROUTE_JOIN", true, Color.GRAY);
    public static final Tag ITE_ADJUST_LAST_HOP_REQ = new Tag("ADJUST_LAST_HOP_REQ", true, Color.BLACK);
    public static final Tag ITE_ADJUST_LAST_HOP_REP = new Tag("ADJUST_LAST_HOP_REP", true, Color.BLACK);
    public static final Tag ITE_NONE = new Tag("NONE", true, Color.BLACK);
    public static final Tag ITE_INVOKE = new Tag("INVOKE", true, Color.BLACK);
    public static final Tag ITE_JOIN = new Tag("JOIN", true, Color.GRAY);
    public static final Tag ITE_REPLY = new Tag("REPLY", true, Color.GRAY);
    public static final Tag REC_ROUTE_NONE = new Tag("ROUTE_NONE", true, Color.BLACK);
    public static final Tag REC_ROUTE_INVOKE = new Tag("ROUTE_INVOKE", true, Color.BLACK);
    public static final Tag REC_ROUTE_JOIN = new Tag("ROUTE_JOIN", true, Color.GRAY);
    public static final Tag REC_NONE = new Tag("NONE", true, Color.BLACK);
    public static final Tag REC_INVOKE = new Tag("INVOKE", true, Color.BLACK);
    public static final Tag REC_JOIN = new Tag("JOIN", true, Color.GRAY);
    public static final Tag REC_ACK = new Tag("ACK", true, Color.GRAY);
    public static final Tag REC_RESULT = new Tag("RESULT", true, Color.GRAY);
    public static final Tag REQ_CONNECT = new Tag("REQ_CONNECT", true, Color.GRAY);
    public static final Tag REP_CONNECT = new Tag("REP_CONNECT", true, Color.GRAY);
    public static final Tag UPDATE_FINGER_TABLE = new Tag("UPDATE_FINGER_TABLE", true, Color.GRAY);
    public static final Tag ACK_FINGER_TABLE = new Tag("ACK_FINGER_TABLE", true, Color.GRAY);
    public static final Tag REQ_PREDECESSOR = new Tag("REQ_PREDECESSOR", true, Color.GRAY);
    public static final Tag REP_PREDECESSOR = new Tag("REP_PREDECESSOR", true, Color.GRAY);
    public static final Tag UPDATE_ROUTING_TABLE = new Tag("UPDATE_ROUTING_TABLE", true, Color.GRAY);
    public static final Tag MULTICAST_JOINING_NODE = new Tag("MULTICAST_JOINING_NODE", true, Color.GRAY);
    public static final Tag MULTICAST_ACK = new Tag("MULTICAST_ACK", true, Color.GRAY);
    public static final Tag NOTIFY_JOINING_NODE = new Tag("NOTIFY_JOINING_NODE", true, Color.GRAY);
    public static final Tag REQ_LEAF_SET = new Tag("REQ_LEAF_SET", true, Color.GRAY);
    public static final Tag REP_LEAF_SET = new Tag("REP_LEAF_SET", true, Color.GRAY);
    public static final Tag REQ_ROUTING_TABLE_ROW = new Tag("REQ_ROUTING_TABLE_ROW", true, Color.GRAY);
    public static final Tag REP_ROUTING_TABLE_ROW = new Tag("REP_ROUTING_TABLE_ROW", true, Color.GRAY);
    public static final Tag PUT = new Tag("PUT", true, Color.GRAY);
    public static final Tag GET = new Tag("GET", true, Color.GRAY);
    public static final Tag REMOVE = new Tag("REMOVE", true, Color.GRAY);
    public static final Tag DHT_REPLY = new Tag("DHT_REPLY", true, Color.GRAY);
    public static final Tag GET_NEAR_TO = new Tag("GET_NEAR_FROM", true, Color.GRAY);
    public static final Tag REPLY_NEAR_TO = new Tag("REPLY_NEAR_TO", true, Color.GRAY);
    public static final Tag CONNECT = new Tag("CONNECT", true, Color.GRAY);
    public static final Tag ACK_CONNECT = new Tag("ACK_CONNECT", true, Color.GRAY);
    public static final Tag NACK_CONNECT = new Tag("NACK_CONNECT", true, Color.GRAY);
    public static final Tag DISCONNECT = new Tag("DISCONNECT", true, Color.GRAY);
    public static final Tag DISCONNECT_AND_REFUSE = new Tag("DISCONNECT_AND_REFUSE", true, Color.GRAY);
    public static final Tag MULTICAST = new Tag("MULTICAST", true, Color.GRAY);
    public static final Tag ENCAPSULATED = new Tag("ENCAPSULATED", false, Color.GRAY);
    public static final Tag MESSAGE_SENT = new Tag("MESSAGE_SENT", false, Color.GRAY);
    public static final Tag DELETE_NODE = new Tag("DELETE_NODE", false, Color.GRAY);
    public static final Tag EMPHASIZE_NODE = new Tag("EMPHASIZE_NODE", false, Color.GRAY);
    public static final Tag MARK_ID = new Tag("MARK_ID", false, Color.GRAY);
    public static final Tag CONNECT_NODES = new Tag("CONNECT_NODES", false, Color.GRAY);
    public static final Tag DISCONNECT_NODES = new Tag("DISCONNECT_NODES", false, Color.GRAY);
    public static final Tag STAT_PING = new Tag("STAT_PING", false, Color.GRAY);
    public static final Tag STAT_ACK = new Tag("STAT_ACK", false, Color.GRAY);
    public static final Tag REQ_NEIGHBORS = new Tag("REQ_NEIGHBORS", false, Color.GRAY);
    public static final Tag REP_NEIGHBORS = new Tag("REP_NEIGHBORS", false, Color.GRAY);

    protected Tag(int i, String name, boolean toBeReportedToStatCollector, Color color) {
        lastNumber = i;
        this.number = lastNumber++;
        this.name = name;
        this.toBeReportedToStatCollector = toBeReportedToStatCollector;
        this.color = color;
        colorTable.put(this.number, color);
        tagTable.put(this.number, this);
        stringTable.put(this.number, name);
    }

    protected Tag(String name, boolean toBeReportedToStatCollector, Color color) {
        this.number = lastNumber++;
        this.name = name;
        this.toBeReportedToStatCollector = toBeReportedToStatCollector;
        this.color = color;
        colorTable.put(this.number, color);
        tagTable.put(this.number, this);
        stringTable.put(this.number, name);
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public static Color getColor(int number) {
        Color ret = colorTable.get(number);
        if (ret == null) {
            ret = Color.BLACK;
        }
        return ret;
    }

    public static boolean toBeReportedToStatCollector(int tag) {
        Tag o = Tag.getTagByNumber(tag);
        if (o != null) {
            return o.toBeReportedToStatCollector;
        }
        return true;
    }

    public static Tag getTagByNumber(int number) {
        return tagTable.get(number);
    }

    public static String getStringByNumber(int number) {
        String ret = stringTable.get(number);
        if (ret == null) {
            ret = String.valueOf(number);
        }
        return ret;
    }
}

