/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.emulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.Signature;
import ow.messaging.emulator.EmuHostID;
import ow.messaging.emulator.EmuMessage;
import ow.messaging.emulator.EmuMessageSender;
import ow.messaging.emulator.EmuMessagingAddress;
import ow.messaging.emulator.EmuMessagingConfiguration;
import ow.messaging.emulator.EmuMessagingProvider;
import ow.msgstat.StatCollectorConfiguration;
import ow.msgstat.StatCollectorFactory;
import ow.msgstat.StatReporter;

public final class EmuMessageReceiver
implements MessageReceiver,
Runnable {
    private static final Logger logger = Logger.getLogger("messaging");
    private final Map<Thread, EmuMessageSender> senderTable = Collections.synchronizedMap(new HashMap());
    protected static Map<EmuMessagingAddress, Queue<EmuMessage>> queueTable = new HashMap<EmuMessagingAddress, Queue<EmuMessage>>();
    private Queue<EmuMessage> messageQueue;
    private EmuMessagingConfiguration config;
    private EmuMessagingAddress selfAddr;
    private EmuMessagingProvider provider;
    private List<MessageHandler> handlerList = new ArrayList<MessageHandler>();
    private Thread receiverThread = null;
    private final StatReporter statReporter;
    private final boolean useThreadPool;

    protected EmuMessageReceiver(EmuMessagingConfiguration config, EmuHostID selfInetAddr, int port, EmuMessagingProvider provider) {
        this.config = config;
        this.selfAddr = new EmuMessagingAddress(selfInetAddr, port);
        this.provider = provider;
        StatCollectorConfiguration conf = StatCollectorFactory.getDefaultConfiguration();
        this.statReporter = StatCollectorFactory.getStatReporter(conf, this.provider, this.getSender());
        this.useThreadPool = config.getUseThreadPool();
    }

    public MessagingAddress getSelfAddress() {
        return this.selfAddr;
    }

    public int getPort() {
        return this.selfAddr.getPort();
    }

    public StatReporter getStatReporter() {
        return this.statReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        this.messageQueue = new LinkedList<EmuMessage>();
        Map<EmuMessagingAddress, Queue<EmuMessage>> map = queueTable;
        synchronized (map) {
            queueTable.put(this.selfAddr, this.messageQueue);
        }
        if (this.receiverThread == null) {
            this.receiverThread = new Thread(this);
            this.receiverThread.setDaemon(true);
            this.receiverThread.setName("EmuMessageReceiver: " + this.selfAddr);
            this.receiverThread.setPriority(Thread.currentThread().getPriority() + 1);
            this.receiverThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.receiverThread != null) {
            this.receiverThread.interrupt();
            this.receiverThread = null;
        }
        Map<EmuMessagingAddress, Queue<EmuMessage>> map = queueTable;
        synchronized (map) {
            queueTable.remove(this.selfAddr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageSender getSender() {
        EmuMessageSender sender;
        Thread curThread = Thread.currentThread();
        Map<Thread, EmuMessageSender> map = this.senderTable;
        synchronized (map) {
            sender = this.senderTable.get(curThread);
            if (sender == null) {
                sender = new EmuMessageSender(this.config, this.provider.getEmuHostID(), this.provider, this.statReporter);
                this.senderTable.put(curThread, sender);
            }
        }
        return sender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(MessageHandler handler) {
        ArrayList<MessageHandler> newHandlerList = new ArrayList<MessageHandler>();
        EmuMessageReceiver emuMessageReceiver = this;
        synchronized (emuMessageReceiver) {
            newHandlerList.addAll(this.handlerList);
            newHandlerList.add(handler);
            this.handlerList = newHandlerList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(MessageHandler handler) {
        ArrayList<MessageHandler> newHandlerList = new ArrayList<MessageHandler>();
        EmuMessageReceiver emuMessageReceiver = this;
        synchronized (emuMessageReceiver) {
            newHandlerList.addAll(this.handlerList);
            newHandlerList.remove(handler);
            this.handlerList = newHandlerList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (true) {
                EmuMessage emuMsg = null;
                Queue<EmuMessage> queue = this.messageQueue;
                synchronized (queue) {
                    while (true) {
                        try {
                            emuMsg = this.messageQueue.poll();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                        if (emuMsg != null) break;
                        this.messageQueue.wait();
                    }
                }
                this.processAMessage(emuMsg);
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.INFO, "interrupted: " + e);
            return;
        }
    }

    private void processAMessage(EmuMessage emuMsg) {
        byte[] acceptableSig;
        byte[] sig = emuMsg.getMessage().getSignature();
        if (!Signature.match(sig, acceptableSig = this.provider.getMessageSignature())) {
            return;
        }
        EmuMessageHandler msgHandler = new EmuMessageHandler(emuMsg);
        if (this.useThreadPool) {
            this.provider.getThreadPool().submit(msgHandler);
        } else {
            Thread t = new Thread(msgHandler);
            t.setDaemon(false);
            t.setName("EmuMessageHandler: " + this.selfAddr);
            t.start();
        }
    }

    private class EmuMessageHandler
    implements Runnable {
        private EmuMessage emuMsg;

        EmuMessageHandler(EmuMessage msg) {
            this.emuMsg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EmuMessageSender sender;
            List currentHandlerList;
            Message ret = null;
            EmuMessageReceiver emuMessageReceiver = EmuMessageReceiver.this;
            synchronized (emuMessageReceiver) {
                currentHandlerList = EmuMessageReceiver.this.handlerList;
            }
            for (MessageHandler handler : currentHandlerList) {
                try {
                    ret = handler.process(this.emuMsg.getMessage());
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "A MessageHandler threw an Exception.", e);
                }
            }
            if (ret != null && (sender = this.emuMsg.getSender()) != null) {
                sender.setReturnedMessage(this.emuMsg.getUniqueID(), ret);
                EmuMessageReceiver.this.statReporter.notifyStatCollectorOfMessageSent(this.emuMsg.getMessage().getSource().getAddress(), ret);
            }
        }
    }
}

