/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.emulator;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.messaging.Message;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.emulator.EmuHostID;
import ow.messaging.emulator.EmuMessage;
import ow.messaging.emulator.EmuMessageReceiver;
import ow.messaging.emulator.EmuMessagingAddress;
import ow.messaging.emulator.EmuMessagingConfiguration;
import ow.messaging.emulator.EmuMessagingProvider;
import ow.messaging.timeoutcalc.TimeoutCalculator;
import ow.msgstat.StatReporter;
import ow.util.Timer;

public final class EmuMessageSender
implements MessageSender {
    private static final Logger logger = Logger.getLogger("messaging");
    protected final EmuHostID selfAddr;
    private final EmuMessagingProvider provider;
    private final TimeoutCalculator timeoutCalc;
    private StatReporter statReporter;
    private final boolean useTimerForTimeout;
    private static final int TAG_NULL = -1;
    private final Map<Integer, Message> returnedMsgMap = new HashMap<Integer, Message>();

    protected EmuMessageSender(EmuMessagingConfiguration config, EmuHostID selfAddress, EmuMessagingProvider provider, StatReporter statReporter) {
        this.selfAddr = selfAddress;
        this.provider = provider;
        this.timeoutCalc = provider.getTimeoutCalculator();
        this.statReporter = statReporter;
        this.useTimerForTimeout = config.getUseTimerForTimeout();
    }

    public void setStatReporter(StatReporter statReporter) {
        this.statReporter = statReporter;
    }

    public void send(MessagingAddress dest, Message msg) throws IOException {
        EmuMessage emuMsg = new EmuMessage(msg, this);
        this.send(dest, emuMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(MessagingAddress dest, EmuMessage emuMsg) throws IOException {
        byte[] sig = this.provider.getMessageSignature();
        emuMsg.getMessage().setSignature(sig);
        EmuMessagingAddress emuAddr = (EmuMessagingAddress)dest;
        Queue<EmuMessage> msgQueue = null;
        Object object = EmuMessageReceiver.queueTable;
        synchronized (object) {
            msgQueue = EmuMessageReceiver.queueTable.get(emuAddr);
        }
        if (msgQueue == null) {
            logger.log(Level.WARNING, "No such node: " + emuAddr);
            if (this.statReporter != null) {
                Message innerMsg = emuMsg.getMessage();
                this.statReporter.notifyStatCollectorOfDeletedNode(innerMsg.getSource(), dest, innerMsg.getTag());
            }
            throw new IOException("No such node: " + emuAddr);
        }
        object = msgQueue;
        synchronized (object) {
            boolean offered = msgQueue.offer(emuMsg);
            if (offered) {
                msgQueue.notify();
            } else {
                logger.log(Level.WARNING, "A Message could not be queued.");
            }
        }
        if (this.statReporter != null) {
            this.statReporter.notifyStatCollectorOfMessageSent(dest, emuMsg.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message sendAndReceive(MessagingAddress dest, Message msg) throws IOException {
        Message nullMsg;
        Message ret = null;
        EmuMessage emuMsg = new EmuMessage(msg, this);
        int msgID = emuMsg.getUniqueID();
        Object object = this.returnedMsgMap;
        synchronized (object) {
            nullMsg = new Message(null, -1, new Serializable[0]);
            this.returnedMsgMap.put(msgID, nullMsg);
        }
        object = nullMsg;
        synchronized (object) {
            block21: {
                long timeout = this.timeoutCalc.calculateTimeout(dest);
                long start = System.currentTimeMillis();
                this.send(dest, emuMsg);
                if (this.useTimerForTimeout) {
                    try {
                        Timer.setTimer(timeout);
                        while (true) {
                            Map<Integer, Message> map = this.returnedMsgMap;
                            synchronized (map) {
                                ret = this.returnedMsgMap.get(msgID);
                                if (ret == null || ret.getTag() != -1) {
                                    this.returnedMsgMap.remove(msgID);
                                    break;
                                }
                            }
                            nullMsg.wait();
                        }
                        Timer.clearTimer();
                        this.timeoutCalc.updateRTT(dest, (int)(System.currentTimeMillis() - start));
                    }
                    catch (Exception e) {
                        Thread.interrupted();
                        logger.log(Level.INFO, "interrupted: " + e);
                        throw new IOException("Timeout:" + timeout + " msec.");
                    }
                }
                long timelimit = System.currentTimeMillis() + timeout;
                while (true) {
                    Map<Integer, Message> map = this.returnedMsgMap;
                    synchronized (map) {
                        ret = this.returnedMsgMap.get(msgID);
                        if (ret == null || ret.getTag() != -1) {
                            this.returnedMsgMap.remove(msgID);
                            this.timeoutCalc.updateRTT(dest, (int)(System.currentTimeMillis() - start));
                            break block21;
                        }
                    }
                    long currentTimeout = timelimit - System.currentTimeMillis();
                    if (currentTimeout <= 0L) break;
                    try {
                        nullMsg.wait(currentTimeout);
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "sendAndReceive() interrupted.", e);
                    }
                }
                throw new IOException("Timeout:" + timeout + " msec.");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setReturnedMessage(int msgID, Message msg) {
        Message nullMsg;
        msg.setSignature(this.provider.getMessageSignature());
        Object object = this.returnedMsgMap;
        synchronized (object) {
            nullMsg = this.returnedMsgMap.get(msgID);
            this.returnedMsgMap.put(msgID, msg);
        }
        object = nullMsg;
        synchronized (object) {
            nullMsg.notify();
        }
    }
}

