/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.tcp;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

class ConnectionPool {
    private static final Logger logger = Logger.getLogger("messaging");
    private int size;
    private Map<SocketAddress, SocketChannel> connectionMap;
    private Random rnd;

    ConnectionPool(int size) {
        this.size = size;
        this.connectionMap = Collections.synchronizedMap(new HashMap());
        this.rnd = new Random(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketChannel get(SocketAddress dest) throws IOException {
        SocketChannel sock = this.connectionMap.remove(dest);
        if (sock != null) {
            logger.log(Level.INFO, "A Socket found in the hashtable: ", sock);
            return sock;
        }
        try {
            sock = SocketChannel.open(dest);
            logger.log(Level.INFO, "A new socket created: " + dest);
        }
        catch (IOException e) {
            logger.log(Level.INFO, "A Socket could not be created: " + dest);
            throw e;
        }
        if (this.connectionMap.size() + 1 >= this.size) {
            logger.log(Level.INFO, "Connection pool is full. Remove an entry.");
            int removeIdx = this.rnd.nextInt(this.size);
            SocketAddress removedKey = null;
            Map<SocketAddress, SocketChannel> map = this.connectionMap;
            synchronized (map) {
                for (SocketAddress key : this.connectionMap.keySet()) {
                    if (removeIdx == 0) {
                        removedKey = key;
                        break;
                    }
                    --removeIdx;
                }
                this.connectionMap.remove(removedKey);
            }
        }
        return sock;
    }

    public void put(SocketAddress addr, SocketChannel sock) {
        this.connectionMap.put(addr, sock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<SocketAddress, SocketChannel> map = this.connectionMap;
        synchronized (map) {
            for (SocketChannel sock : this.connectionMap.values()) {
                try {
                    sock.close();
                }
                catch (IOException e) {}
            }
            this.connectionMap.clear();
        }
    }
}

