/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ow.messaging.AbstractMessagingProvider;
import ow.messaging.MessageReceiver;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingConfiguration;
import ow.messaging.MessagingProvider;
import ow.messaging.tcp.TCPMessageReceiver;
import ow.messaging.tcp.TCPMessagingAddress;
import ow.messaging.tcp.TCPMessagingConfiguration;
import ow.messaging.timeoutcalc.RTTBasedTimeoutCalculator;
import ow.messaging.timeoutcalc.StaticTimeoutCalculator;
import ow.messaging.timeoutcalc.TimeoutCalculator;

public class TCPMessagingProvider
extends AbstractMessagingProvider {
    private static final String NAME = "TCP";
    private final Map<Integer, TCPMessageReceiver> receiverTable = Collections.synchronizedMap(new HashMap());
    private InetAddress selfAddress = null;
    private TimeoutCalculator timeoutCalculator = null;
    private MessagingAddress statCollectorAddress = null;

    public String getName() {
        return NAME;
    }

    public boolean isReliable() {
        return true;
    }

    public MessagingConfiguration getDefaultConfiguration() {
        return new TCPMessagingConfiguration();
    }

    public MessageReceiver getReceiver(MessagingConfiguration config, int port) throws IOException {
        return this.getReceiver(config, port, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageReceiver getReceiver(MessagingConfiguration config, int port, int portRange) throws IOException {
        TCPMessagingProvider tCPMessagingProvider = this;
        synchronized (tCPMessagingProvider) {
            this.timeoutCalculator = config.getDoTimeoutCalculation() ? new StaticTimeoutCalculator(config) : new RTTBasedTimeoutCalculator(config);
        }
        TCPMessageReceiver receiver = this.receiverTable.get(port);
        if (receiver == null) {
            receiver = new TCPMessageReceiver(this.selfAddress, port, portRange, (TCPMessagingConfiguration)config, this);
            this.receiverTable.put(port, receiver);
            receiver.start();
        }
        return receiver;
    }

    public TCPMessagingAddress getMessagingAddress(String hostname, int port) throws UnknownHostException {
        return new TCPMessagingAddress(hostname, port);
    }

    public TCPMessagingAddress getMessagingAddress(String hostAndPort) throws UnknownHostException {
        return new TCPMessagingAddress(hostAndPort);
    }

    public TCPMessagingAddress getMessagingAddress(int port) {
        return new TCPMessagingAddress(port);
    }

    public TimeoutCalculator getTimeoutCalculator() {
        return this.timeoutCalculator;
    }

    public MessagingAddress getStatCollectorAddress() {
        return this.statCollectorAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessagingAddress setStatCollectorAddress(MessagingAddress addr) {
        MessagingAddress old;
        TCPMessagingProvider tCPMessagingProvider = this;
        synchronized (tCPMessagingProvider) {
            old = this.statCollectorAddress;
            this.statCollectorAddress = addr;
        }
        return old;
    }

    public MessagingProvider substitute() {
        return null;
    }

    public void setDefaultSelfAddress(String host) throws UnknownHostException {
        this.selfAddress = InetAddress.getByName(host);
    }
}

