/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import ow.messaging.util.AccessController;

public final class AccessControlledServerSocket
extends ServerSocket {
    private AccessController ac = null;

    public AccessControlledServerSocket(AccessController ac) throws IOException {
        this.ac = ac;
    }

    public AccessControlledServerSocket(AccessController ac, int port) throws IOException {
        super(port);
        this.ac = ac;
    }

    public AccessControlledServerSocket(AccessController ac, int port, int backlog) throws IOException {
        super(port, backlog);
        this.ac = ac;
    }

    public AccessControlledServerSocket(AccessController ac, int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
        this.ac = ac;
    }

    public AccessControlledServerSocket() throws IOException {
    }

    public AccessControlledServerSocket(int port) throws IOException {
        super(port);
    }

    public AccessControlledServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    public AccessControlledServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
    }

    public void setAccessController(AccessController ac) {
        this.ac = ac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket accept() throws IOException {
        Socket sock;
        while (true) {
            sock = super.accept();
            AccessControlledServerSocket accessControlledServerSocket = this;
            synchronized (accessControlledServerSocket) {
                if (this.ac != null) {
                    if (this.ac.allow(sock.getInetAddress())) {
                        break;
                    }
                    sock.close();
                }
            }
        }
        return sock;
    }
}

