/*
 * Decompiled with CFR 0.152.
 */
package ow.routing;

import java.io.Serializable;
import ow.id.IDAddressPair;

public final class RoutingResult
implements Serializable {
    private final IDAddressPair[] route;
    private final IDAddressPair[] neighbors;

    public RoutingResult(IDAddressPair[] r, IDAddressPair[] n) {
        this.route = r;
        this.neighbors = n;
    }

    public IDAddressPair[] getRoute() {
        return this.route;
    }

    public IDAddressPair[] getNeighbors() {
        return this.neighbors;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("RoutingResult { ");
        if (this.route != null && this.route.length > 0) {
            sb.append("route: ");
            sb.append(this.route[0].getAddress());
            for (i = 1; i < this.route.length; ++i) {
                sb.append(", ");
                sb.append(this.route[i].getAddress());
            }
            sb.append(" ");
        }
        sb.append("neighbors: ");
        if (this.neighbors == null) {
            sb.append("(null)");
        } else if (this.neighbors.length <= 0) {
            sb.append("(length=0)");
        } else {
            sb.append(this.neighbors[0].getAddress());
            for (i = 1; i < this.neighbors.length; ++i) {
                sb.append(", ");
                sb.append(this.neighbors[i].getAddress());
            }
        }
        sb.append(" }");
        return sb.toString();
    }
}

