/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.MessageReceiver;
import ow.messaging.MessageSender;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingProvider;
import ow.messaging.Tag;
import ow.msgstat.impl.StatCollectorMessageFactory;
import ow.routing.CallbackOnNodeFailure;
import ow.routing.CallbackOnRoute;
import ow.routing.CallbackResultFilter;
import ow.routing.RoutingAlgorithm;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingRuntime;
import ow.routing.RoutingService;
import ow.routing.RoutingServiceConfiguration;
import ow.routing.impl.RoutingDriverMessageFactory;

public abstract class AbstractRoutingDriver
implements RoutingRuntime,
RoutingService {
    protected static final Logger logger = Logger.getLogger("routing");
    protected RoutingServiceConfiguration config;
    private MessagingProvider msgProvider;
    protected MessageReceiver receiver;
    protected MessageSender sender;
    protected ExecutorService threadPool;
    protected final boolean adjustRoot;
    protected final boolean queryToAllContacts;
    protected RoutingAlgorithm algorithm;
    protected MessagingAddress statCollectorAddress;
    private IDAddressPair selfIDAddressPair;
    private int selfAddressHashCode;
    Map<Integer, List<MessageHandler>> handlerTable = Collections.synchronizedMap(new HashMap());
    private List<CallbackOnRoute> routeCallbackList = Collections.synchronizedList(new ArrayList(1));
    private List<CallbackOnNodeFailure> failureCallbackList = Collections.synchronizedList(new ArrayList(1));

    protected AbstractRoutingDriver(RoutingServiceConfiguration conf, MessagingProvider provider, MessageReceiver receiver, ExecutorService threadPool, RoutingAlgorithmConfiguration algoConf, ID selfID) throws IOException {
        this.msgProvider = provider;
        this.receiver = receiver;
        this.sender = this.receiver.getSender();
        this.threadPool = threadPool;
        this.adjustRoot = algoConf.adjustRoot();
        this.queryToAllContacts = algoConf.queryToAllContacts();
        if (selfID != null) {
            selfID = selfID.copy(algoConf.getIDSizeInByte());
        } else {
            MessagingAddress selfAddr = this.receiver.getSelfAddress();
            selfID = ID.getHashcodeBasedID(selfAddr, algoConf.getIDSizeInByte());
        }
        this.init(conf, selfID);
    }

    private void init(RoutingServiceConfiguration conf, ID selfID) throws IOException {
        this.config = conf;
        this.receiver.addHandler(new RoutingDrvMessageHandler());
        MessagingAddress selfAddr = this.receiver.getSelfAddress();
        this.selfIDAddressPair = new IDAddressPair(selfID, selfAddr);
        this.selfAddressHashCode = selfAddr.hashCode();
        this.prepareHandlers();
    }

    public void leave() {
        this.algorithm.reset();
    }

    public synchronized void stop() {
        logger.log(Level.INFO, "RoutingDriver#stop() called.");
        if (this.receiver != null) {
            this.receiver.stop();
            this.receiver = null;
            this.sender = null;
        }
        if (this.algorithm != null) {
            this.algorithm.stop();
            this.algorithm = null;
        }
    }

    public synchronized void suspend() {
        if (this.receiver != null) {
            this.receiver.stop();
        }
        if (this.algorithm != null) {
            this.algorithm.suspend();
        }
    }

    public synchronized void resume() {
        if (this.receiver != null) {
            this.receiver.start();
        }
        if (this.algorithm != null) {
            this.algorithm.resume();
        }
    }

    public RoutingServiceConfiguration getConfiguration() {
        return this.config;
    }

    public MessagingProvider getMessagingProvider() {
        return this.msgProvider;
    }

    public MessageSender getMessageSender() {
        return this.receiver.getSender();
    }

    public RoutingAlgorithm getRoutingAlgorithm() {
        return this.algorithm;
    }

    public RoutingAlgorithm setRoutingAlgorithm(RoutingAlgorithm algo) {
        RoutingAlgorithm old = this.algorithm;
        if (this.algorithm == null) {
            this.algorithm = algo;
        }
        return old;
    }

    public void setStatCollectorAddress(MessagingAddress address) {
        this.statCollectorAddress = address;
        this.msgProvider.setStatCollectorAddress(address);
    }

    public String routeToString(IDAddressPair[] route) {
        if (route == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (IDAddressPair hop : route) {
            sb.append("\n ");
            sb.append(hop);
        }
        sb.append("\n]");
        return sb.toString();
    }

    public boolean ping(MessageSender sender, IDAddressPair target) throws IOException {
        Message msg = RoutingDriverMessageFactory.getPingMessage(this.selfIDAddressPair);
        Message ret = sender.sendAndReceive(target.getAddress(), msg);
        int tag = ret.getTag();
        if (tag == Tag.ACK.getNumber()) {
            this.algorithm.touch(target);
            return true;
        }
        logger.log(Level.WARNING, "Received message should be ACK, but it is: " + tag);
        if (this.algorithm != null) {
            this.algorithm.fail(target);
        }
        return false;
    }

    public IDAddressPair getSelfIDAddressPair() {
        MessagingAddress currentSelfAddress = this.receiver.getSelfAddress();
        if (currentSelfAddress.hashCode() != this.selfAddressHashCode) {
            this.selfIDAddressPair.setAddress(currentSelfAddress);
            this.selfAddressHashCode = currentSelfAddress.hashCode();
        }
        return this.selfIDAddressPair;
    }

    public void addMessageHandler(int tag, MessageHandler handler) {
        List<MessageHandler> handlerList = this.handlerTable.get(tag);
        if (handlerList == null) {
            handlerList = Collections.synchronizedList(new ArrayList(1));
            this.handlerTable.put(tag, handlerList);
        }
        handlerList.add(handler);
    }

    public void addCallbackOnRoute(CallbackOnRoute callback) {
        this.routeCallbackList.add(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Serializable invokeCallbacks(ID target, CallbackResultFilter filter, int tag, Serializable[] args, IDAddressPair lastHop, boolean onRootNode) {
        MessagingAddress lastHopAddress = lastHop != null ? lastHop.getAddress() : null;
        logger.log(Level.INFO, "Invoke " + this.routeCallbackList.size() + " callbacks. lastHop: " + lastHopAddress + ", onRootNode: " + onRootNode + ", on " + this.selfIDAddressPair.getAddress());
        Serializable result = null;
        List<CallbackOnRoute> list = this.routeCallbackList;
        synchronized (list) {
            for (CallbackOnRoute cb : this.routeCallbackList) {
                Serializable ret = cb.process(target, tag, args, filter, lastHop, onRootNode);
                if (ret == null) continue;
                result = ret;
            }
        }
        return result;
    }

    public void addCallbackOnNodeFailure(CallbackOnNodeFailure callback) {
        this.failureCallbackList.add(callback);
    }

    protected void fail(IDAddressPair failedNode) {
        if (this.algorithm != null) {
            this.algorithm.fail(failedNode);
        }
        for (CallbackOnNodeFailure cb : this.failureCallbackList) {
            cb.fail(failedNode);
        }
    }

    private void prepareHandlers() {
        MessageHandler handler = new MessageHandler(){

            public Message process(Message msg) {
                Message ret = RoutingDriverMessageFactory.getAckMessage(AbstractRoutingDriver.this.selfIDAddressPair);
                return ret;
            }
        };
        this.addMessageHandler(Tag.PING.getNumber(), handler);
        handler = new MessageHandler(){

            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                int num = (Integer)contents[0];
                MessagingAddress reqSource = msg.getSource().getAddress();
                AbstractRoutingDriver.this.msgProvider.setStatCollectorAddress(reqSource);
                IDAddressPair[] neighbors = AbstractRoutingDriver.this.algorithm.neighbors(num);
                return StatCollectorMessageFactory.getRepNeighbors(AbstractRoutingDriver.this.selfIDAddressPair, neighbors);
            }
        };
        this.addMessageHandler(Tag.REQ_NEIGHBORS.getNumber(), handler);
    }

    private class RoutingDrvMessageHandler
    implements MessageHandler {
        private RoutingDrvMessageHandler() {
        }

        public Message process(Message msg) {
            IDAddressPair src;
            Message ret = null;
            int tag = msg.getTag();
            List<MessageHandler> handlerList = AbstractRoutingDriver.this.handlerTable.get(tag);
            if (handlerList != null) {
                for (MessageHandler handler : handlerList) {
                    try {
                        ret = handler.process(msg);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "A MessageHandler threw an Exception.", e);
                    }
                }
            }
            if (AbstractRoutingDriver.this.algorithm != null && (src = msg.getSource()).getID() != null && src.getAddress() != null) {
                AbstractRoutingDriver.this.algorithm.touch(src);
            }
            return ret;
        }
    }
}

