/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.kademlia;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ow.id.IDAddressPair;
import ow.routing.RoutingAlgorithm;
import ow.routing.kademlia.Kademlia;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KBucket
implements Iterable<IDAddressPair> {
    private final List<IDAddressPair> internalList = new LinkedList<IDAddressPair>();
    private final int capacity;
    private final Kademlia algorithm;
    private volatile IDAddressPair nodeBeingChecked = null;

    KBucket(RoutingAlgorithm algorithm, int capacity) {
        this.algorithm = (Kademlia)algorithm;
        this.capacity = capacity;
    }

    synchronized void clear() {
        this.internalList.clear();
    }

    public synchronized int size() {
        return this.internalList.size();
    }

    public synchronized boolean remove(IDAddressPair elem) {
        return this.internalList.remove(elem);
    }

    private IDAddressPair peekHead() {
        IDAddressPair ret = null;
        try {
            ret = this.internalList.get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return ret;
    }

    private IDAddressPair removeHead() {
        IDAddressPair ret = null;
        try {
            ret = this.internalList.remove(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToTail(IDAddressPair newEntry) {
        IDAddressPair head;
        KBucket kBucket = this;
        synchronized (kBucket) {
            if (this.nodeBeingChecked != null) {
                return;
            }
            if (this.internalList.remove(newEntry)) {
                this.internalList.add(newEntry);
                return;
            }
            if (this.internalList.size() < this.capacity) {
                this.internalList.add(newEntry);
                return;
            }
            this.nodeBeingChecked = head = this.peekHead();
        }
        boolean toReplace = this.algorithm.toReplace(head, newEntry);
        KBucket kBucket2 = this;
        synchronized (kBucket2) {
            this.nodeBeingChecked = null;
            if (toReplace) {
                this.removeHead();
                this.appendToTail(newEntry);
            } else {
                this.removeHead();
                this.appendToTail(head);
            }
        }
    }

    @Override
    public synchronized Iterator<IDAddressPair> iterator() {
        return this.internalList.iterator();
    }

    public synchronized IDAddressPair[] toArray() {
        IDAddressPair[] ret = new IDAddressPair[this.internalList.size()];
        return this.internalList.toArray(ret);
    }
}

