/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.kademlia;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.comparator.AlgoBasedTowardTargetIDAddrComparator;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingService;
import ow.routing.impl.AbstractRoutingAlgorithm;
import ow.routing.kademlia.KBucket;
import ow.routing.kademlia.KademliaConfiguration;
import ow.tool.dhtshell.XmlRpcDHTServer;
import ow.util.HTMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Kademlia
extends AbstractRoutingAlgorithm {
    private KademliaConfiguration config;
    private int numKBuckets;
    private KBucket[] kBuckets;

    protected Kademlia(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        try {
            this.config = (KademliaConfiguration)config;
        }
        catch (ClassCastException e) {
            throw new InvalidAlgorithmParameterException("The given config is not KademliaConfiguration.");
        }
        this.numKBuckets = this.config.getIDSizeInByte() * 8;
        int kBucketLength = this.config.getKBucketLength();
        this.kBuckets = new KBucket[this.numKBuckets];
        for (int i = 0; i < this.numKBuckets; ++i) {
            this.kBuckets[i] = new KBucket(this, kBucketLength);
        }
    }

    @Override
    public synchronized void reset() {
        for (int i = 0; i < this.numKBuckets; ++i) {
            this.kBuckets[i].clear();
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public synchronized void suspend() {
    }

    @Override
    public synchronized void resume() {
    }

    @Override
    public BigInteger distance(ID to, ID from) {
        BigInteger toInt = to.toBigInteger();
        BigInteger fromInt = from.toBigInteger();
        return fromInt.xor(toInt);
    }

    @Override
    public IDAddressPair[] closestTo(ID targetID, int maxNum, RoutingContext cxt) {
        int i;
        KBucket kb;
        IDAddressPair[] results = new IDAddressPair[maxNum];
        BigInteger distance = this.distance(targetID, this.selfIDAddress.getID());
        int highestSetBit = distance.bitLength() - 1;
        AlgoBasedTowardTargetIDAddrComparator comparator = new AlgoBasedTowardTargetIDAddrComparator(this, targetID);
        int index = 0;
        if (highestSetBit >= 0) {
            kb = this.kBuckets[highestSetBit];
            if ((index = this.pickNodes(index, results, kb, comparator)) >= results.length) {
                return results;
            }
            for (i = highestSetBit - 1; i >= 0; --i) {
                if (!distance.testBit(i) || (index = this.pickNodes(index, results, kb = this.kBuckets[i], comparator)) < results.length) continue;
                return results;
            }
        }
        results[index++] = this.selfIDAddress;
        if (index >= results.length) {
            return results;
        }
        if (highestSetBit >= 0) {
            for (i = 0; i < highestSetBit; ++i) {
                if (distance.testBit(i) || (index = this.pickNodes(index, results, kb = this.kBuckets[i], comparator)) < results.length) continue;
                return results;
            }
        }
        for (i = highestSetBit + 1; i < this.numKBuckets; ++i) {
            kb = this.kBuckets[i];
            index = this.pickNodes(index, results, kb, comparator);
        }
        IDAddressPair[] ret = new IDAddressPair[index];
        System.arraycopy(results, 0, ret, 0, index);
        return ret;
    }

    @Override
    public IDAddressPair[] neighbors(int maxNum) {
        return this.closestTo(this.selfIDAddress.getID(), maxNum, null);
    }

    private int pickNodes(int index, IDAddressPair[] dest, KBucket kb, Comparator<IDAddressPair> comparator) {
        IDAddressPair[] result = kb.toArray();
        Arrays.sort(result, comparator);
        int resultLen = result.length;
        int destLen = dest.length;
        int copyLen = Math.min(destLen - index, resultLen);
        System.arraycopy(result, 0, dest, index, copyLen);
        return index + copyLen;
    }

    @Override
    public IDAddressPair[] adjustRoot(ID rootCandidate) {
        return null;
    }

    @Override
    public boolean toReplace(IDAddressPair existingEntry, IDAddressPair newEntry) {
        if (existingEntry.equals(newEntry)) {
            return false;
        }
        boolean pingSucceeded = false;
        try {
            pingSucceeded = this.runtime.ping(this.sender, existingEntry);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "An IOException thrown during ping() from " + this.selfIDAddress.getAddress() + " to " + existingEntry.getAddress());
        }
        return !pingSucceeded;
    }

    @Override
    public void join(IDAddressPair[] neighbors) {
    }

    @Override
    public void join(IDAddressPair joiningNode, IDAddressPair lastHop, boolean isFinalHop) {
        logger.log(Level.INFO, "On " + this.selfIDAddress.getAddress() + ", " + "Kademlia#join(" + joiningNode.getAddress() + ", " + (lastHop != null ? lastHop.getAddress() : "null") + ", " + isFinalHop + ") called.");
    }

    @Override
    public void touch(IDAddressPair from) {
        BigInteger distance = this.distance(from.getID(), this.selfIDAddress.getID());
        int highestSetBit = distance.bitLength() - 1;
        if (highestSetBit < 0) {
            return;
        }
        KBucket kb = this.kBuckets[highestSetBit];
        kb.appendToTail(from);
    }

    @Override
    public void forget(IDAddressPair failedNode) {
        BigInteger distance = this.distance(failedNode.getID(), this.selfIDAddress.getID());
        int highestSetBit = distance.bitLength() - 1;
        if (highestSetBit < 0) {
            return;
        }
        KBucket kb = this.kBuckets[highestSetBit];
        kb.remove(failedNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRoutingTableString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.numKBuckets; ++i) {
            KBucket kb = this.kBuckets[i];
            if (kb.size() <= 0) continue;
            sb.append("\n ").append(i).append(":");
            KBucket kBucket = kb;
            synchronized (kBucket) {
                for (IDAddressPair pair : kb) {
                    sb.append("\n  ").append(pair);
                }
                continue;
            }
        }
        sb.append("\n]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRoutingTableHTMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table>\n");
        for (int i = 0; i < this.numKBuckets; ++i) {
            KBucket kb = this.kBuckets[i];
            if (kb.size() <= 0) continue;
            sb.append("<tr><td>" + HTMLUtil.stringInHTML(Integer.toString(i)) + "</td><td></td><td></td></tr>\n");
            KBucket kBucket = kb;
            synchronized (kBucket) {
                for (IDAddressPair pair : kb) {
                    String url = XmlRpcDHTServer.convertMessagingAddressToURL(pair.getAddress());
                    sb.append("<tr><td></td><td><a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a></td><td>" + HTMLUtil.stringInHTML(pair.getID().toString()) + "</td></tr>\n");
                }
                continue;
            }
        }
        sb.append("</table>\n");
        return sb.toString();
    }
}

