/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.koorde;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.Random;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.IDAddressRoutingContextTriplet;
import ow.id.comparator.AlgoBasedFromSrcIDComparator;
import ow.id.comparator.AlgoBasedTowardTargetIDComparator;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.Tag;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingResult;
import ow.routing.RoutingService;
import ow.routing.koorde.KoordeConfiguration;
import ow.routing.koorde.KoordeMessageFactory;
import ow.routing.koorde.KoordeRoutingContext;
import ow.routing.linearwalker.LinearWalker;
import ow.tool.dhtshell.XmlRpcDHTServer;
import ow.util.HTMLUtil;

public final class Koorde
extends LinearWalker {
    private KoordeConfiguration config;
    private final int digitBits;
    private ID km;
    private IDAddressPair[] edges;
    private int numEdges;
    private Thread edgeFixer;

    protected Koorde(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        try {
            this.config = (KoordeConfiguration)config;
        }
        catch (ClassCastException e) {
            throw new InvalidAlgorithmParameterException("The given config is not KoordeConfiguration.");
        }
        this.digitBits = this.config.getDigitBits();
        this.km = this.selfIDAddress.getID().shiftLeft(this.digitBits);
        this.numEdges = this.config.getNumEdges();
        this.edges = new IDAddressPair[this.numEdges];
        EdgeFixer r = new EdgeFixer(this.config, this.km);
        this.edgeFixer = new Thread(r);
        this.edgeFixer.setName("EdgeFixer");
        this.edgeFixer.setDaemon(true);
        this.edgeFixer.start();
    }

    public synchronized void reset() {
        super.reset();
        this.edges = new IDAddressPair[this.config.getNumEdges()];
    }

    public synchronized void stop() {
        logger.log(Level.INFO, "Koorde#stop() called.");
        super.stop();
        if (this.edgeFixer != null) {
            this.edgeFixer.interrupt();
            this.edgeFixer = null;
        }
    }

    public RoutingContext initialRoutingContext(ID targetID) {
        int idSize = this.config.getIDSizeInByte();
        ID selfID = this.selfIDAddress.getID();
        ID successor = this.successorList.first().getID();
        BigInteger selfIDPlusOneInteger = selfID.toBigInteger().add(BigInteger.ONE);
        ID selfIDPlusOne = ID.getID(selfIDPlusOneInteger, idSize);
        selfIDPlusOneInteger = selfIDPlusOne.toBigInteger();
        BigInteger successorInteger = successor.toBigInteger();
        BigInteger targetIDInteger = targetID.toBigInteger();
        if (this.selfIDAddress.getID().equals(successor)) {
            return new KoordeRoutingContext(targetID, selfIDPlusOne, this.digitBits);
        }
        AlgoBasedFromSrcIDComparator fromSelfComparator = new AlgoBasedFromSrcIDComparator(this, selfID);
        int i = 0;
        for (i = 0; i < this.idSizeInBit && selfIDPlusOneInteger.testBit(this.idSizeInBit - 1 - i) == successorInteger.testBit(this.idSizeInBit - 1 - i); ++i) {
        }
        i /= this.digitBits;
        int iter = (this.idSizeInBit - 1) / this.digitBits + 1;
        while (i <= iter) {
            int shiftWidth = this.idSizeInBit - this.digitBits * i;
            BigInteger mask = BigInteger.ONE.shiftLeft(shiftWidth).subtract(BigInteger.ONE);
            BigInteger topBitsOfK = targetIDInteger.shiftRight(this.digitBits * i);
            BigInteger baseID = selfIDPlusOneInteger;
            ID imgID = ID.getID(baseID.andNot(mask).or(topBitsOfK), idSize);
            if (fromSelfComparator.compare(imgID, successor) <= 0) {
                ID kshift = ID.getID(targetIDInteger.shiftLeft(shiftWidth), idSize);
                return new KoordeRoutingContext(kshift, imgID, this.digitBits);
            }
            baseID = successorInteger;
            imgID = ID.getID(baseID.andNot(mask).or(topBitsOfK), idSize);
            if (fromSelfComparator.compare(imgID, successor) <= 0) {
                ID kshift = ID.getID(targetIDInteger.shiftLeft(shiftWidth), idSize);
                return new KoordeRoutingContext(kshift, imgID, this.digitBits);
            }
            baseID = selfIDPlusOneInteger.add(BigInteger.ONE.shiftLeft(shiftWidth));
            imgID = ID.getID(baseID.andNot(mask).or(topBitsOfK), idSize);
            if (fromSelfComparator.compare(imgID, successor) <= 0) {
                ID kshift = ID.getID(targetIDInteger.shiftLeft(shiftWidth), idSize);
                return new KoordeRoutingContext(kshift, imgID, this.digitBits);
            }
            baseID = successorInteger.subtract(BigInteger.ONE.shiftLeft(shiftWidth));
            imgID = ID.getID(baseID.andNot(mask).or(topBitsOfK), idSize);
            if (fromSelfComparator.compare(imgID, successor) <= 0) {
                ID kshift = ID.getID(targetIDInteger.shiftLeft(shiftWidth), idSize);
                return new KoordeRoutingContext(kshift, imgID, this.digitBits);
            }
            ++i;
        }
        return new KoordeRoutingContext(targetID, selfIDPlusOne, this.digitBits);
    }

    public IDAddressPair[] closestTo(ID target, int maxNum, RoutingContext cxt) {
        AlgoBasedFromSrcIDComparator fromSelfComparator;
        KoordeRoutingContext context = (KoordeRoutingContext)cxt;
        ID successor = this.successorList.first().getID();
        ID i = context.getI();
        AlgoBasedTowardTargetIDComparator toSuccComparator = new AlgoBasedTowardTargetIDComparator(this, successor);
        ID selfID = this.selfIDAddress.getID();
        if (toSuccComparator.compare(selfID, target) > 0) {
            IDAddressPair[] ret;
            if (this.predecessor != null && !this.predecessor.equals(this.selfIDAddress)) {
                ret = new IDAddressRoutingContextTriplet[2];
                ret[1] = new IDAddressRoutingContextTriplet(this.predecessor, context);
            } else {
                ret = new IDAddressRoutingContextTriplet[]{new IDAddressRoutingContextTriplet(this.selfIDAddress, context)};
            }
            return ret;
        }
        if (toSuccComparator.compare(selfID, i) > 0) {
            if (this.edges[0] != null) {
                RoutingContext updatedContext = context.next();
                IDAddressPair[] ret = new IDAddressRoutingContextTriplet[this.edges.length];
                for (int j = 0; j < this.edges.length; ++j) {
                    if (this.edges[j] == null) continue;
                    ret[j] = new IDAddressRoutingContextTriplet(this.edges[j], updatedContext);
                }
                return ret;
            }
            context = null;
        }
        ID cutPoint = (fromSelfComparator = new AlgoBasedFromSrcIDComparator(this, selfID)).compare(target, i) < 0 ? target : i;
        IDAddressPair[] succList = this.successorList.closestNodes(cutPoint, false);
        IDAddressPair[] ret = new IDAddressRoutingContextTriplet[succList.length];
        for (int j = 0; j < succList.length; ++j) {
            ret[j] = new IDAddressRoutingContextTriplet(succList[j], context);
        }
        return ret;
    }

    public void forget(IDAddressPair failedNode) {
        super.forget(failedNode);
        this.forget(this.edges, failedNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forget(IDAddressPair[] edges, IDAddressPair failedNode) {
        IDAddressPair[] iDAddressPairArray = this.edges;
        synchronized (this.edges) {
            int nEdges = this.edges.length;
            for (int i = 0; i < nEdges; ++i) {
                if (!failedNode.equals(this.edges[i])) continue;
                int j = i;
                for (j = i; j < i - 1; ++j) {
                    this.edges[j] = this.edges[j + 1];
                }
                this.edges[j] = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public String getRoutingTableString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getRoutingTableString());
        sb.append("\n");
        sb.append((1 << this.digitBits) + "m: ");
        sb.append(this.km);
        sb.append("\n");
        sb.append("de Bruijn edge and backups: [");
        for (int i = 0; i < this.config.getNumEdges() && this.edges[i] != null; ++i) {
            sb.append("\n ");
            sb.append(this.edges[i]);
        }
        sb.append("\n]");
        return sb.toString();
    }

    public String getRoutingTableHTMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getRoutingTableHTMLString());
        sb.append("<h4>" + HTMLUtil.stringInHTML(Integer.toString(1 << this.digitBits)) + "m</h4>\n");
        sb.append(HTMLUtil.stringInHTML(this.km.toString()) + "\n");
        sb.append("<h4>De Bruijn edges and backups</h4>\n");
        for (int i = 0; i < this.config.getNumEdges() && this.edges[i] != null; ++i) {
            String url = XmlRpcDHTServer.convertMessagingAddressToURL(this.edges[i].getAddress());
            sb.append("<a href=\"" + url + "\">" + HTMLUtil.stringInHTML(url) + "</a><br>\n");
        }
        return sb.toString();
    }

    public void prepareHandlers() {
        super.prepareHandlers();
        MessageHandler handler = new MessageHandler(){

            public Message process(Message msg) {
                return KoordeMessageFactory.getRepPredecessorMessage(Koorde.this.selfIDAddress, Koorde.this.predecessor);
            }
        };
        this.runtime.addMessageHandler(Tag.REQ_PREDECESSOR.getNumber(), handler);
    }

    private class EdgeFixer
    implements Runnable {
        private Random rnd = new Random(System.currentTimeMillis());
        ID km;

        EdgeFixer(KoordeConfiguration config, ID km) {
            this.km = km;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long interval = Koorde.this.config.getFixEdgeMinInterval();
            try {
                while (true) {
                    boolean backupsToBeUpdated;
                    if (Koorde.this.suspended) {
                        Koorde koorde = Koorde.this;
                        synchronized (koorde) {
                            Koorde.this.wait();
                        }
                    }
                    if (Koorde.this.stopped) break;
                    RoutingResult res = Koorde.this.runtime.routeToClosestNode(this.km, 1);
                    IDAddressPair[] route = res.getRoute();
                    IDAddressPair oldEdge = Koorde.this.edges[0];
                    try {
                        ((Koorde)Koorde.this).edges[0] = ((IDAddressRoutingContextTriplet)route[route.length - 1]).getIDAddressPair();
                    }
                    catch (ClassCastException e) {
                        ((Koorde)Koorde.this).edges[0] = route[route.length - 1];
                    }
                    int nEdges = Koorde.this.edges.length;
                    boolean bl = backupsToBeUpdated = Koorde.this.edges[0] != null && (!Koorde.this.edges[0].equals(oldEdge) || Koorde.this.edges[nEdges - 1] == null);
                    if (backupsToBeUpdated) {
                        Message reqMsg = KoordeMessageFactory.getReqPredecessorMessage(Koorde.this.selfIDAddress);
                        IDAddressPair[] updatedEdges = new IDAddressPair[Koorde.this.edges.length];
                        IDAddressPair[] iDAddressPairArray = Koorde.this.edges;
                        synchronized (iDAddressPairArray) {
                            System.arraycopy(Koorde.this.edges, 0, updatedEdges, 0, Koorde.this.edges.length);
                        }
                        for (int i = 0; i < nEdges - 1; ++i) {
                            IDAddressPair pred;
                            Message repMsg = null;
                            if (updatedEdges[i] == null) break;
                            if (updatedEdges[i].equals(Koorde.this.selfIDAddress)) {
                                pred = Koorde.this.predecessor;
                            } else {
                                try {
                                    repMsg = Koorde.this.sender.sendAndReceive(updatedEdges[i].getAddress(), reqMsg);
                                }
                                catch (IOException e) {
                                    logger.log(Level.WARNING, "Failed to send a REQ_PREDECESSOR msg or receive a REP_PREDECESSOR msg.", e);
                                    Koorde.this.forget(updatedEdges, updatedEdges[i]);
                                    --i;
                                    continue;
                                }
                                Serializable[] contents = repMsg.getContents();
                                pred = (IDAddressPair)contents[0];
                            }
                            if (updatedEdges[i].equals(pred)) break;
                            updatedEdges[i + 1] = pred;
                        }
                        IDAddressPair[] i = Koorde.this.edges;
                        synchronized (i) {
                            System.arraycopy(updatedEdges, 0, Koorde.this.edges, 0, Koorde.this.edges.length);
                        }
                    }
                    if (backupsToBeUpdated) {
                        interval = Koorde.this.config.getFixEdgeMinInterval();
                    } else if ((interval += Koorde.this.config.getFixEdgeIntervalDelta()) > Koorde.this.config.getFixEdgeMaxInterval()) {
                        interval = Koorde.this.config.getFixEdgeMaxInterval();
                    }
                    double playRatio = Koorde.this.config.getFixEdgeIntervalPlayRatio();
                    double intervalRatio = 1.0 - playRatio + playRatio * 2.0 * this.rnd.nextDouble();
                    Thread.sleep((long)((double)interval * intervalRatio));
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "EdgeFixer interrupted and die.", e);
            }
        }
    }
}

