/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.pastry;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.id.comparator.AlgoBasedTowardTargetIDAddrComparator;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.Tag;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingService;
import ow.routing.pastry.LeafSet;
import ow.routing.pastry.PastryConfiguration;
import ow.routing.pastry.PastryMessageFactory;
import ow.routing.plaxton.Plaxton;
import ow.routing.plaxton.RoutingTableRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pastry
extends Plaxton {
    private PastryConfiguration config;
    LeafSet leafSet = null;
    Thread routingTableMaintainerThread = null;
    private final BigInteger ID_SPACE_SIZE = BigInteger.ONE.shiftLeft(this.idSizeInBit);
    private final BigInteger HALF_ID_SPACE_SIZE = BigInteger.ONE.shiftLeft(this.idSizeInBit - 1);

    protected Pastry(RoutingAlgorithmConfiguration conf, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(conf, routingSvc);
        this.config = (PastryConfiguration)conf;
        if (this.config.getUseLeafSet()) {
            if (routingSvc != null) {
                this.leafSet = new LeafSet(this, this.config.getIDSizeInByte() * 8, routingSvc.getSelfIDAddressPair(), this.config.getLeafSetOneSideSize());
            } else {
                logger.log(Level.SEVERE, "routingSvc is null. test?");
            }
        }
        this.prepareHandlers();
        if (this.config.getDoPeriodicRoutingTableMaintenance()) {
            RoutingTableMaintainer r = new RoutingTableMaintainer();
            this.routingTableMaintainerThread = new Thread(r);
            this.routingTableMaintainerThread.setName("RoutingTableMaintainer");
            this.routingTableMaintainerThread.setDaemon(true);
            this.routingTableMaintainerThread.start();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.leafSet.clear();
    }

    @Override
    public BigInteger distance(ID to, ID from) {
        BigInteger fromInt;
        BigInteger toInt = to.toBigInteger();
        BigInteger distance = toInt.subtract(fromInt = from.toBigInteger());
        if (distance.compareTo(BigInteger.ZERO) < 0) {
            distance = distance.add(this.ID_SPACE_SIZE);
        }
        if (distance.compareTo(this.HALF_ID_SPACE_SIZE) < 0) {
            distance = distance.shiftLeft(1);
        } else {
            distance = this.ID_SPACE_SIZE.subtract(distance);
            distance = distance.shiftLeft(1);
            distance = distance.subtract(BigInteger.ONE);
        }
        return distance;
    }

    @Override
    public IDAddressPair[] closestTo(ID target, int maxNum, RoutingContext cxt) {
        if (this.leafSet != null) {
            IDAddressPair targetIDAddress = new IDAddressPair(target, null);
            if (target.equals(this.selfIDAddress.getID()) || this.leafSet.coversWithSmallerSet(targetIDAddress) || this.leafSet.coversWithLargerSet(targetIDAddress)) {
                IDAddressPair[] ret = this.leafSet.closestNodes(target, maxNum);
                return ret;
            }
        }
        return super.closestTo(target, maxNum, cxt);
    }

    @Override
    protected Collection<IDAddressPair> traverseDownward(int rowIndex, int startingCol, ID target, int maxNum) {
        AlgoBasedTowardTargetIDAddrComparator comparator = new AlgoBasedTowardTargetIDAddrComparator(this, target);
        ArrayList<IDAddressPair> results = new ArrayList<IDAddressPair>();
        this.traverseDownward(results, comparator, rowIndex, startingCol, target, maxNum);
        return results;
    }

    private void traverseDownward(Collection<IDAddressPair> results, Comparator<IDAddressPair> comparator, int rowIndex, int startingCol, ID target, int maxNum) {
        RoutingTableRow row = this.routingTable.getRow(rowIndex);
        int rowSize = row.size();
        if (this.pickCloseEntry(results, comparator, maxNum, target, row, rowIndex, startingCol, 0)) {
            return;
        }
        TreeSet<IDAddressPair> sortedList = new TreeSet<IDAddressPair>(comparator);
        for (int i = 1; i < rowSize; ++i) {
            sortedList.clear();
            int colIndex = startingCol + i;
            if (colIndex < rowSize && this.pickCloseEntry(sortedList, comparator, maxNum, target, row, rowIndex, colIndex, 1) || (colIndex = startingCol - i) >= 0 && this.pickCloseEntry(sortedList, comparator, maxNum, target, row, rowIndex, colIndex, -1)) break;
            results.addAll(sortedList);
        }
    }

    private void traverseDownwardFromLeftToRight(Collection<IDAddressPair> results, int rowIndex, ID target, int maxNum) {
        RoutingTableRow row = this.routingTable.getRow(rowIndex);
        int rowSize = row.size();
        for (int i = 0; i < rowSize && !this.pickCloseEntry(results, null, maxNum, target, row, rowIndex, i, 1); ++i) {
        }
    }

    private void traverseDownwardFromRightToLeft(Collection<IDAddressPair> results, int rowIndex, ID target, int maxNum) {
        RoutingTableRow row = this.routingTable.getRow(rowIndex);
        int rowSize = row.size();
        for (int i = rowSize - 1; i >= 0 && !this.pickCloseEntry(results, null, maxNum, target, row, rowIndex, i, -1); --i) {
        }
    }

    private boolean pickCloseEntry(Collection<IDAddressPair> results, Comparator<IDAddressPair> comparator, int maxNum, ID target, RoutingTableRow row, int rowIndex, int colIndex, int exploringSide) {
        IDAddressPair entry = row.get(colIndex);
        if (entry == null) {
            return false;
        }
        if (entry.equals(this.selfIDAddress) && rowIndex + 1 < this.idSizeInDigit) {
            if (exploringSide > 0) {
                this.traverseDownwardFromLeftToRight(results, rowIndex + 1, target, maxNum - results.size());
            } else if (exploringSide < 0) {
                this.traverseDownwardFromRightToLeft(results, rowIndex + 1, target, maxNum - results.size());
            } else {
                this.traverseDownward(results, comparator, rowIndex + 1, colIndex, target, maxNum - results.size());
            }
            return results.size() >= maxNum;
        }
        results.add(entry);
        return results.size() >= maxNum;
    }

    @Override
    protected List<IDAddressPair> traverseUpward(int rowIndex, int maxNum) {
        ArrayList<IDAddressPair> results = new ArrayList<IDAddressPair>();
        ID selfID = this.selfIDAddress.getID();
        block0: for (int i = rowIndex - 1; i >= 0; --i) {
            RoutingTableRow row = this.routingTable.getRow(i);
            int rowSize = row.size();
            int digit = this.getDigit(selfID, i);
            for (int j = 0; j < rowSize; ++j) {
                IDAddressPair entry;
                int colIndex;
                if (j != 0 && (colIndex = digit + j) < rowSize && (entry = row.get(colIndex)) != null) {
                    results.add(entry);
                    if (results.size() >= maxNum) break block0;
                }
                if ((colIndex = (digit - 1 - j) % rowSize) < 0 || (entry = row.get(colIndex)) == null) continue;
                results.add(entry);
                if (results.size() >= maxNum) break block0;
            }
        }
        return results;
    }

    @Override
    public void join(IDAddressPair joiningNode, IDAddressPair lastHop, boolean isFinalHop) {
        int selfMatchDigits;
        int startRow;
        if (lastHop == null) {
            return;
        }
        if (lastHop.equals(joiningNode)) {
            startRow = 0;
        } else {
            int lastMatchBits = ID.matchLengthFromMSB(lastHop.getID(), joiningNode.getID());
            int lastMatchDigits = lastMatchBits / this.digitSize;
            startRow = lastMatchDigits + 1;
        }
        int selfMatchBits = ID.matchLengthFromMSB(this.selfIDAddress.getID(), joiningNode.getID());
        int endRow = selfMatchDigits = selfMatchBits / this.digitSize;
        if (isFinalHop || endRow >= this.idSizeInDigit) {
            endRow = this.idSizeInDigit - 1;
        }
        if (startRow < this.idSizeInDigit && startRow <= endRow) {
            int rowSetWidth = endRow - startRow + 1;
            HashSet<IDAddressPair> nodeSet = new HashSet<IDAddressPair>();
            for (int i = 0; i < rowSetWidth; ++i) {
                RoutingTableRow row = this.routingTable.getRow(startRow + i);
                nodeSet.addAll(row.getAllNodes());
            }
            nodeSet.remove(joiningNode);
            IDAddressPair[] nodes = new IDAddressPair[nodeSet.size()];
            nodeSet.toArray(nodes);
            IDAddressPair[] smallerLeafSet = null;
            IDAddressPair[] largerLeafSet = null;
            if (this.leafSet != null && isFinalHop) {
                smallerLeafSet = this.leafSet.getArrayOfSmallerSet(joiningNode);
                largerLeafSet = this.leafSet.getArrayOfLargerSet(joiningNode);
            }
            Message reqMsg = PastryMessageFactory.getUpdateRoutingTableMessage(this.selfIDAddress, nodes, smallerLeafSet, largerLeafSet);
            try {
                this.sender.send(joiningNode.getAddress(), reqMsg);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to send a UPDATE_ROUNTING_TABLE message: " + joiningNode.getAddress(), e);
                this.fail(joiningNode);
            }
        }
    }

    @Override
    public void touch(IDAddressPair from) {
        super.touch(from);
        if (this.leafSet != null) {
            this.leafSet.add(from);
        }
    }

    @Override
    public void forget(IDAddressPair failedNode) {
        super.forget(failedNode);
        if (this.leafSet != null) {
            this.leafSet.remove(failedNode);
            this.checkAndFillLeafSet();
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.routingTableMaintainerThread != null) {
            this.routingTableMaintainerThread.interrupt();
            this.routingTableMaintainerThread = null;
        }
    }

    @Override
    public String getRoutingTableString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.routingTable.toString());
        if (this.leafSet != null) {
            sb.append("\n");
            sb.append("leaf set: ");
            sb.append(this.leafSet.toString());
        }
        return sb.toString();
    }

    @Override
    public String getRoutingTableHTMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h4>Plaxton Routing Table</h5>\n");
        sb.append(this.routingTable.toHTMLString());
        if (this.leafSet != null) {
            sb.append("<h4>Leaf Set</h4>");
            sb.append(this.leafSet.toHTMLString());
        }
        return sb.toString();
    }

    private void checkAndFillLeafSet() {
        IDAddressPair largest;
        IDAddressPair smallest;
        if (this.leafSet.coversEntireRing()) {
            return;
        }
        int oneSideSize = this.leafSet.getOneSideSize();
        if (this.leafSet.getNumberOfSmallerNodes() < oneSideSize && (smallest = this.leafSet.getSmallestNode()) != null) {
            this.requestLeafSet(smallest);
        }
        if (this.leafSet.getNumberOfLargerNodes() < oneSideSize && (largest = this.leafSet.getLargestNode()) != null) {
            this.requestLeafSet(largest);
        }
    }

    private void requestLeafSet(IDAddressPair target) {
        Message reqMsg = PastryMessageFactory.getReqLeafSetMessage(this.selfIDAddress);
        try {
            Message repMsg = this.sender.sendAndReceive(target.getAddress(), reqMsg);
            Serializable[] contents = repMsg.getContents();
            IDAddressPair[] smallerLeafSet = (IDAddressPair[])contents[0];
            IDAddressPair[] largerLeafSet = (IDAddressPair[])contents[1];
            this.leafSet.merge(smallerLeafSet);
            this.leafSet.merge(largerLeafSet);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to send or receive REQ/REP_LEAF_SET message.", e);
            this.fail(target);
        }
    }

    @Override
    protected void prepareHandlers() {
        super.prepareHandlers();
        MessageHandler handler = new MessageHandler(){

            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                IDAddressPair[] nodes = (IDAddressPair[])contents[0];
                IDAddressPair[] smallerLeafSet = (IDAddressPair[])contents[1];
                IDAddressPair[] largerLeafSet = (IDAddressPair[])contents[2];
                HashSet<IDAddressPair> nodesInMessage = new HashSet<IDAddressPair>();
                logger.log(Level.INFO, "UPDATE_ROUTING_TABLE received: # of nodes: " + nodes.length + " on " + Pastry.this.selfIDAddress.getAddress());
                for (IDAddressPair p : nodes) {
                    Pastry.this.routingTable.merge(p);
                    nodesInMessage.add(p);
                }
                if (Pastry.this.leafSet != null) {
                    if (smallerLeafSet != null) {
                        Pastry.this.leafSet.merge(smallerLeafSet);
                        for (IDAddressPair p : smallerLeafSet) {
                            if (p == null) continue;
                            nodesInMessage.add(p);
                        }
                    }
                    if (largerLeafSet != null) {
                        Pastry.this.leafSet.merge(largerLeafSet);
                        for (IDAddressPair p : largerLeafSet) {
                            if (p == null) continue;
                            nodesInMessage.add(p);
                        }
                    }
                    Pastry.this.checkAndFillLeafSet();
                }
                for (IDAddressPair node : nodesInMessage) {
                    if (node.equals(Pastry.this.selfIDAddress)) continue;
                    logger.log(Level.INFO, Pastry.this.selfIDAddress.getAddress() + " send a PING msg to " + node.getAddress());
                    boolean pingSucceeded = false;
                    try {
                        pingSucceeded = Pastry.this.runtime.ping(Pastry.this.sender, node);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "An IOException thrown by ping().", e);
                    }
                    if (pingSucceeded) continue;
                    Pastry.this.forget(node);
                }
                return null;
            }
        };
        this.runtime.addMessageHandler(Tag.UPDATE_ROUTING_TABLE.getNumber(), handler);
        handler = new MessageHandler(){

            public Message process(Message msg) {
                IDAddressPair[] smallerLeafSet = Pastry.this.leafSet.getArrayOfSmallerSet(null);
                IDAddressPair[] largerLeafSet = Pastry.this.leafSet.getArrayOfLargerSet(null);
                Message repMsg = PastryMessageFactory.getRepLeafSetMessage(Pastry.this.selfIDAddress, smallerLeafSet, largerLeafSet);
                return repMsg;
            }
        };
        this.runtime.addMessageHandler(Tag.REQ_LEAF_SET.getNumber(), handler);
        handler = new MessageHandler(){

            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                int rowIndex = (Integer)contents[0];
                RoutingTableRow row = Pastry.this.routingTable.getRow(rowIndex);
                Message repMsg = PastryMessageFactory.getRepRoutingTableRowMessage(Pastry.this.selfIDAddress, row);
                return repMsg;
            }
        };
        this.runtime.addMessageHandler(Tag.REQ_ROUTING_TABLE_ROW.getNumber(), handler);
    }

    private class RoutingTableMaintainer
    implements Runnable {
        private Random rnd = new Random(System.currentTimeMillis());

        private RoutingTableMaintainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                block7: while (true) {
                    long pause = Pastry.this.config.getRoutingTableMaintenanceInterval();
                    double playRatio = Pastry.this.config.getRoutingTableMaintenanceIntervalPlayRatio();
                    double pauseRatio = 1.0 - playRatio + playRatio * 2.0 * this.rnd.nextDouble();
                    Thread.sleep((long)((double)pause * pauseRatio));
                    int rowIndex = 0;
                    while (true) {
                        if (rowIndex >= Pastry.this.idSizeInDigit || Pastry.this.stopped) continue block7;
                        while (Pastry.this.suspended) {
                            Pastry pastry = Pastry.this;
                            synchronized (pastry) {
                                Pastry.this.wait();
                            }
                        }
                        RoutingTableRow row = Pastry.this.routingTable.getRow(rowIndex);
                        if (!row.isEmpty()) {
                            int colCandidate = this.rnd.nextInt(1 << Pastry.this.digitSize);
                            IDAddressPair target = null;
                            for (int i = 0; i < 1 << Pastry.this.digitSize; ++i) {
                                int index = (colCandidate + i) % (1 << Pastry.this.digitSize);
                                target = row.get(index);
                                if (Pastry.this.selfIDAddress.equals(target)) {
                                    target = null;
                                }
                                if (target != null) break;
                            }
                            if (target != null) {
                                Message msg = PastryMessageFactory.getReqRoutingTableRowMessage(Pastry.this.selfIDAddress, rowIndex);
                                Message repMsg = null;
                                try {
                                    repMsg = Pastry.this.sender.sendAndReceive(target.getAddress(), msg);
                                }
                                catch (IOException e) {
                                    logger.log(Level.WARNING, "Failed to send or receive a REQ/REP_ROUTING_TABLE_ROW message.", e);
                                    Pastry.this.fail(target);
                                }
                                if (repMsg != null) {
                                    Serializable[] contents = repMsg.getContents();
                                    row = (RoutingTableRow)contents[0];
                                    logger.log(Level.INFO, Pastry.this.selfIDAddress.getAddress() + " received REP_ROUTING_TABLE_ROW: " + row);
                                    Pastry.this.routingTable.merge(row);
                                }
                            }
                        }
                        ++rowIndex;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "RoutingTableMainainer interrupted and die.", e);
                return;
            }
        }
    }
}

