/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.plaxton;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingContext;
import ow.routing.RoutingService;
import ow.routing.impl.AbstractRoutingAlgorithm;
import ow.routing.plaxton.PlaxtonConfiguration;
import ow.routing.plaxton.RoutingTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Plaxton
extends AbstractRoutingAlgorithm {
    private PlaxtonConfiguration config;
    private final Random rnd;
    protected boolean stopped = false;
    protected boolean suspended = false;
    protected final int idSizeInBit;
    protected final int idSizeInDigit;
    protected final int digitSize;
    protected final RoutingTable routingTable;

    protected Plaxton(RoutingAlgorithmConfiguration config, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(config, routingSvc);
        try {
            this.config = (PlaxtonConfiguration)config;
        }
        catch (ClassCastException e) {
            throw new InvalidAlgorithmParameterException("The given config is not KademliaConfiguration.");
        }
        this.rnd = new Random(System.currentTimeMillis());
        this.idSizeInBit = config.getIDSizeInByte() * 8;
        this.idSizeInDigit = (this.idSizeInBit - 1) / this.config.getDigitSize() + 1;
        this.digitSize = this.config.getDigitSize();
        if (routingSvc != null) {
            this.routingTable = new RoutingTable(this.idSizeInDigit, this.digitSize, routingSvc.getSelfIDAddressPair(), this);
        } else {
            logger.log(Level.SEVERE, "routingSvc is null. test?");
            this.routingTable = null;
        }
    }

    @Override
    public void reset() {
        this.routingTable.clear();
    }

    @Override
    public IDAddressPair[] closestTo(ID target, int maxNum, RoutingContext cxt) {
        IDAddressPair[] ret;
        int nMatchBits = ID.matchLengthFromMSB(this.selfIDAddress.getID(), target);
        int nMatchDigits = nMatchBits / this.digitSize;
        int notMatchDigit = this.getDigit(target, nMatchDigits);
        if (nMatchDigits >= this.idSizeInDigit) {
            IDAddressPair[] ret2 = new IDAddressPair[]{this.selfIDAddress};
            return ret2;
        }
        Collection<IDAddressPair> results = this.traverseDownward(nMatchDigits, notMatchDigit, target, maxNum);
        int len = results.size();
        if (len > 0) {
            ret = new IDAddressPair[len];
            results.toArray(ret);
        } else {
            ret = new IDAddressPair[]{this.selfIDAddress};
        }
        return ret;
    }

    @Override
    public IDAddressPair[] neighbors(int maxNum) {
        IDAddressPair[] downwardNodes = this.closestTo(this.selfIDAddress.getID(), maxNum, null);
        if (downwardNodes.length >= maxNum) {
            return downwardNodes;
        }
        List<IDAddressPair> upwardNodesList = this.traverseUpward(this.idSizeInDigit, maxNum - downwardNodes.length);
        IDAddressPair[] upwardNodes = new IDAddressPair[upwardNodesList.size()];
        upwardNodesList.toArray(upwardNodes);
        IDAddressPair[] ret = new IDAddressPair[downwardNodes.length + upwardNodes.length];
        System.arraycopy(downwardNodes, 0, ret, 0, downwardNodes.length);
        System.arraycopy(upwardNodes, 0, ret, downwardNodes.length, upwardNodes.length);
        return ret;
    }

    protected abstract Collection<IDAddressPair> traverseDownward(int var1, int var2, ID var3, int var4);

    protected abstract List<IDAddressPair> traverseUpward(int var1, int var2);

    @Override
    public void stop() {
        this.stopped = true;
    }

    @Override
    public synchronized void suspend() {
        this.suspended = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void resume() {
        this.suspended = false;
        Plaxton plaxton = this;
        synchronized (plaxton) {
            this.notifyAll();
        }
    }

    @Override
    public IDAddressPair[] adjustRoot(ID rootCandidate) {
        return null;
    }

    @Override
    public boolean toReplace(IDAddressPair existingEntry, IDAddressPair newEntry) {
        return this.rnd.nextDouble() < this.config.getReplaceProbability();
    }

    @Override
    public void join(IDAddressPair[] neighbors) {
    }

    @Override
    public void touch(IDAddressPair from) {
        this.routingTable.merge(from);
    }

    @Override
    public void forget(IDAddressPair failedNode) {
        this.routingTable.remove(failedNode);
    }

    @Override
    public String getRoutingTableString() {
        return this.routingTable.toString();
    }

    @Override
    public String getRoutingTableHTMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h4>Plaxton Routing Table</h5>\n");
        sb.append(this.routingTable.toHTMLString());
        return sb.toString();
    }

    protected void prepareHandlers() {
    }

    public int getDigit(ID id, int index) {
        return id.getBits(this.idSizeInBit - (index + 1) * this.digitSize, this.digitSize);
    }

    public ID setDigit(ID id, int index, int digit) {
        int bitOffset = this.idSizeInBit - (index + 1) * this.digitSize;
        BigInteger mask = BigInteger.valueOf(~(-1 << this.digitSize));
        mask = mask.shiftLeft(bitOffset);
        BigInteger digitInt = BigInteger.valueOf(digit);
        digitInt = digitInt.shiftLeft(bitOffset);
        BigInteger v = id.toBigInteger();
        v = v.andNot(mask);
        v = v.or(digitInt);
        return ID.getID(v, id.getSize());
    }
}

