/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.plaxton;

import ow.id.ID;
import ow.id.IDAddressPair;
import ow.routing.plaxton.Plaxton;
import ow.routing.plaxton.RoutingTableRow;

public final class RoutingTable {
    private RoutingTableRow[] rows;
    private final int digitSize;
    private final Plaxton algorithm;
    private final IDAddressPair selfIDAddress;

    public RoutingTable(int rowSize, int digitSize, IDAddressPair selfIDAddress, Plaxton algo) {
        this.digitSize = digitSize;
        this.algorithm = algo;
        this.selfIDAddress = selfIDAddress;
        this.initialize(rowSize);
    }

    private synchronized void initialize(int rowSize) {
        int colSize = 1 << this.digitSize;
        this.rows = new RoutingTableRow[rowSize];
        for (int i = 0; i < rowSize; ++i) {
            RoutingTableRow row;
            int digit = this.algorithm.getDigit(this.selfIDAddress.getID(), i);
            this.rows[i] = row = new RoutingTableRow(i, colSize, digit, this.selfIDAddress);
        }
    }

    void clear() {
        this.initialize(this.rows.length);
    }

    public IDAddressPair set(IDAddressPair entry) {
        int nMatchBits = ID.matchLengthFromMSB(this.selfIDAddress.getID(), entry.getID());
        int nMatchDigits = nMatchBits / this.digitSize;
        if (nMatchDigits >= this.rows.length) {
            return null;
        }
        int notMatchDigit = this.algorithm.getDigit(entry.getID(), nMatchDigits);
        RoutingTableRow row = this.rows[nMatchDigits];
        return row.set(notMatchDigit, entry);
    }

    public IDAddressPair merge(IDAddressPair entry) {
        int nMatchBits = ID.matchLengthFromMSB(this.selfIDAddress.getID(), entry.getID());
        int nMatchDigits = nMatchBits / this.digitSize;
        if (nMatchDigits >= this.rows.length) {
            return null;
        }
        int notMatchDigit = this.algorithm.getDigit(entry.getID(), nMatchDigits);
        RoutingTableRow row = this.rows[nMatchDigits];
        return row.merge(notMatchDigit, entry, this.algorithm);
    }

    public void merge(RoutingTableRow row) {
        for (int i = 0; i < row.size(); ++i) {
            IDAddressPair entry = row.get(i);
            if (entry == null) continue;
            this.merge(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IDAddressPair entry) {
        RoutingTableRow row;
        int nMatchBits = ID.matchLengthFromMSB(this.selfIDAddress.getID(), entry.getID());
        int nMatchDigits = nMatchBits / this.digitSize;
        if (nMatchDigits >= this.rows.length) {
            return false;
        }
        int notMatchDigit = this.algorithm.getDigit(entry.getID(), nMatchDigits);
        RoutingTableRow routingTableRow = row = this.rows[nMatchDigits];
        synchronized (routingTableRow) {
            IDAddressPair existingEntry = row.get(notMatchDigit);
            if (entry.equals(existingEntry)) {
                row.remove(notMatchDigit);
                return true;
            }
        }
        return false;
    }

    public RoutingTableRow getRow(int row) {
        return this.rows[row];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (int i = 0; i < this.rows.length; ++i) {
            RoutingTableRow row = this.rows[i];
            String rowString = row.toString(true);
            if (rowString.length() <= 0) continue;
            sb.append(" ");
            sb.append(rowString);
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public String toHTMLString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table>\n");
        for (int i = 0; i < this.rows.length; ++i) {
            RoutingTableRow row = this.rows[i];
            String rowString = row.toHTMLString();
            if (rowString.length() <= 0) continue;
            sb.append(rowString);
        }
        sb.append("</table>\n");
        return sb.toString();
    }
}

