/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import ow.dht.DHT;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.Shell;
import ow.tool.util.shellframework.ShellContext;
import ow.tool.util.shellframework.ShellServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"source"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "source <file>";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        ShellServer<DHT<String>> shellServer = context.getShellServer();
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        if (args.length < 1) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        if (shellServer != null) {
            for (int i = 0; i < args.length; ++i) {
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), "US-ASCII"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace(out);
                    continue;
                }
                catch (FileNotFoundException e) {
                    out.print("File not found: " + args[0] + "\r\n");
                    continue;
                }
                Shell<DHT<String>> subShell = new Shell<DHT<String>>(in, out, shellServer, dht, false);
                subShell.run();
            }
        }
        return false;
    }
}

