/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.emulator.action;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TimerTask;
import ow.tool.emulator.EmulatorContext;
import ow.tool.emulator.EmulatorControllable;
import ow.tool.emulator.EmulatorMode;
import ow.tool.emulator.Task;

public class InvocationTask
extends TimerTask
implements Task {
    private EmulatorContext cxt;
    private int hostID;
    private final Class clazz;
    private final Method mainMethod;
    private final String[] arguments;
    private int relativePriority;

    public InvocationTask(EmulatorContext emuContext, int hostID, Class clazz, Method mainMethod, String[] args, int relativePriority) {
        this.cxt = emuContext;
        this.hostID = hostID;
        this.clazz = clazz;
        this.mainMethod = mainMethod;
        this.arguments = args;
        this.relativePriority = relativePriority;
    }

    public Task clone() {
        return new InvocationTask(this.cxt, this.hostID, this.clazz, this.mainMethod, this.arguments, this.relativePriority);
    }

    public boolean doesExit() {
        return false;
    }

    public void run() {
        Thread t = null;
        int hostID = this.hostID;
        if (hostID < 0) {
            hostID = this.cxt.getNextHostID();
        }
        if (this.cxt.getEmulatorMode() == EmulatorMode.MASTER) {
            BufferedWriter out = this.cxt.getControlPipe(hostID);
            if (out == null) {
                System.err.println("There is no output pipe associated with host id:" + hostID);
            }
            try {
                out.write("class " + this.clazz.getName() + "\n");
                out.write("arguments");
                for (String arg : this.arguments) {
                    out.write(" " + arg);
                }
                out.write("\n");
                out.write("invoke " + hostID + "\n");
                out.flush();
            }
            catch (IOException e) {
                System.err.println("An IOException thrown during writing to control pipes.");
                e.printStackTrace();
            }
        } else {
            boolean isClazzEmulatorControllable;
            try {
                this.clazz.asSubclass(EmulatorControllable.class);
                isClazzEmulatorControllable = true;
            }
            catch (ClassCastException e) {
                isClazzEmulatorControllable = false;
            }
            Runnable invoker = null;
            invoker = isClazzEmulatorControllable ? new EmuControllableInvoker(this.cxt, hostID, this.clazz, this.arguments) : new GeneralInvoker(this.clazz, this.mainMethod, this.arguments);
            t = new Thread(invoker);
            t.setDaemon(true);
            t.setName("Emulator: " + this.cxt.getCurrentClass().getName());
            t.setPriority(Thread.currentThread().getPriority() + this.relativePriority);
            t.start();
            this.cxt.registerThreadToBeJoined(t);
        }
    }

    private static class EmuControllableInvoker
    implements Runnable {
        private EmulatorContext cxt;
        private int hostID;
        private Class clazz;
        private String[] args;

        EmuControllableInvoker(EmulatorContext cxt, int hostID, Class clazz, String[] args) {
            this.cxt = cxt;
            this.hostID = hostID;
            this.clazz = clazz;
            this.args = args;
        }

        public void run() {
            EmulatorControllable appInstance = null;
            try {
                appInstance = (EmulatorControllable)this.clazz.newInstance();
            }
            catch (Exception e) {
                System.err.println("Exception thrown:");
                e.printStackTrace();
                return;
            }
            try {
                BufferedReader bin = null;
                BufferedWriter bout = null;
                try {
                    PipedInputStream pin = new PipedInputStream();
                    PipedOutputStream pout = new PipedOutputStream(pin);
                    bin = new BufferedReader(new InputStreamReader((InputStream)pin, "US-ASCII"));
                    bout = new BufferedWriter(new OutputStreamWriter((OutputStream)pout, "US-ASCII"));
                }
                catch (IOException e) {
                    System.err.println("An IOException thrown:");
                    e.printStackTrace();
                    return;
                }
                this.cxt.setControlPipe(this.hostID, bout);
                appInstance.start(this.hostID, this.args, bin, this.cxt.getPrintStream());
            }
            catch (Throwable e) {
                System.err.println("An application instance thrown a Throwable:");
                e.printStackTrace();
            }
        }
    }

    private static class GeneralInvoker
    implements Runnable {
        private Class clazz;
        private Method mainMethod;
        private String[] args;

        GeneralInvoker(Class clazz, Method mainMethod, String[] args) {
            this.clazz = clazz;
            this.mainMethod = mainMethod;
            this.args = args;
        }

        public void run() {
            try {
                this.mainMethod.invoke(null, new Object[]{this.args});
            }
            catch (IllegalAccessException e) {
                System.err.println("Could not invoke: " + this.clazz.getName());
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                System.err.println("Exception thrown:");
                t.printStackTrace();
            }
        }
    }
}

