/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.shellframework;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.Interruptible;
import ow.tool.util.shellframework.ShellContext;
import ow.tool.util.shellframework.ShellServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shell<T>
implements Runnable,
Interruptible {
    public static final String CRLF = "\r\n";
    Socket sock;
    ShellServer<T> shellServer;
    BufferedReader in;
    PrintStream out;
    Thread selfThread = null;
    Map<String, Command<T>> commandTable;
    List<Command<T>> commandList;
    T appDepData;
    boolean interactive;

    protected Shell(Socket sock, ShellServer<T> shellServer, Map<String, Command<T>> commandTable, List<Command<T>> commandList, T applicationDependentData) throws Exception {
        this.sock = sock;
        this.shellServer = shellServer;
        InputStream sockInStream = sock.getInputStream();
        this.in = new BufferedReader(new InputStreamReader(sockInStream, "US-ASCII"));
        this.out = new PrintStream(sock.getOutputStream(), false);
        this.commandTable = commandTable;
        this.commandList = commandList;
        this.appDepData = applicationDependentData;
        this.interactive = true;
    }

    public Shell(BufferedReader in, PrintStream out, Class[] commandClasses, T applicationDependentData, boolean interactive) {
        this(in, out, new ShellServer<T>(commandClasses, applicationDependentData, -1), applicationDependentData, interactive);
    }

    public Shell(BufferedReader in, PrintStream out, ShellServer<T> shellServer, T applicationDependentData, boolean interactive) {
        this.sock = null;
        this.shellServer = shellServer;
        this.in = in;
        this.out = out;
        this.commandTable = this.shellServer.getCommandTable();
        this.commandList = this.shellServer.getCommandList();
        this.appDepData = applicationDependentData;
        this.interactive = interactive;
    }

    @Override
    public void run() {
        this.selfThread = Thread.currentThread();
        if (this.shellServer != null) {
            this.shellServer.outputStreamSet.add(this.out);
            this.shellServer.addInterruptible(this);
        }
        while (true) {
            int k;
            if (this.interactive) {
                this.out.print("Ready.\r\n");
                this.out.flush();
            }
            String commandLine = null;
            try {
                commandLine = this.in.readLine();
            }
            catch (IOException e) {
                System.err.print("An Exception thrown when reading from a network.\r\n");
                e.printStackTrace(System.err);
            }
            if (commandLine == null) break;
            if (commandLine.length() > 0 && commandLine.charAt(0) == '\u0000') {
                commandLine = commandLine.substring(1);
            }
            String[] tokens = commandLine.split("\\s+");
            for (k = 0; k < tokens.length && tokens[k].length() <= 0; ++k) {
            }
            if (k >= tokens.length || tokens[k].startsWith("#") || tokens[k].startsWith("%") || tokens[k].startsWith("//")) continue;
            Command<T> command = this.commandTable.get(tokens[k]);
            if (command == null) {
                this.out.print("No such command: " + tokens[k] + CRLF);
                this.out.flush();
                continue;
            }
            String[] args = new String[tokens.length - ++k];
            int i = 0;
            while (i < args.length) {
                args[i] = tokens[k];
                ++i;
                ++k;
            }
            ShellContext<T> context = new ShellContext<T>(this.shellServer, this.appDepData, this.out, this.commandList, args, this.interactive);
            boolean quit = false;
            try {
                quit = command.execute(context);
            }
            catch (Throwable e) {
                this.out.print("An Exception thrown: \r\n");
                e.printStackTrace(this.out);
                this.out.flush();
            }
            if (quit) break;
        }
        if (this.shellServer != null) {
            this.shellServer.outputStreamSet.remove(this.out);
            this.shellServer.removeInterruptible(this);
        }
        if (this.sock != null) {
            int retry = 3;
            while (retry-- > 0) {
                try {
                    this.sock.close();
                    this.sock = null;
                    break;
                }
                catch (IOException e) {
                    System.err.print("SocketChannel#close() threw an IOException.\r\n");
                }
            }
        }
        try {
            this.in.close();
        }
        catch (IOException e) {
            System.err.print("close() threw an IOException.\r\n");
        }
    }

    @Override
    public void interrupt() {
        if (this.selfThread != null && !this.selfThread.equals(Thread.currentThread())) {
            this.selfThread.interrupt();
        }
    }
}

