/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.util.vizframework.geom;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Map;
import ow.id.ID;
import ow.tool.util.vizframework.geom.AbstractGeometryManager;

public class GridGeometryManager
extends AbstractGeometryManager {
    private static final int DEFAULT_SIDE_LENGTH = 420;
    private int numOfNodes;
    private int sideNodes;
    private double sideLength = 420.0;
    private double halfSideLength = this.sideLength * 0.5;

    public GridGeometryManager() {
        this(160);
    }

    private GridGeometryManager(int idSizeInBit) {
        super(idSizeInBit);
    }

    public synchronized void setNumOfNodes(int num) {
        super.setNumOfNodes(num);
        this.numOfNodes = num;
        this.sideNodes = 1 + (int)Math.sqrt(this.numOfNodes - 1);
    }

    public synchronized void setScale(double scale) {
        super.setScale(scale);
        this.sideLength = 420.0 * scale;
        this.halfSideLength = this.sideLength * 0.5;
    }

    public Shape getShapeForMessage(ID src, ID dest) {
        Point2D srcPoint = this.getNodePoint2D(src);
        Point2D destPoint = this.getNodePoint2D(dest);
        return new Line2D.Double(srcPoint, destPoint);
    }

    public Shape getShapeForConnection(ID from, ID to) {
        Point2D srcPoint = this.getNodePoint2D(from);
        Point2D destPoint = this.getNodePoint2D(to);
        return new Line2D.Double(srcPoint, destPoint);
    }

    public Point2D getNodePoint2D(ID id) {
        double y;
        double x;
        Map<ID, Integer> nodeOrderMap = this.getNodeOrderMap();
        Integer orderInteger = nodeOrderMap.get(id);
        if (orderInteger != null) {
            int order = orderInteger;
            int xIndex = order % this.sideNodes;
            int yIndex = order / this.sideNodes;
            x = this.sideLength * (double)xIndex / (double)(this.sideNodes - 1);
            y = this.sideLength * (double)yIndex / (double)(this.sideNodes - 1);
        } else {
            double ratio = id.toBigInteger().doubleValue() / this.idSpaceSize;
            double d = ratio * (double)this.sideNodes;
            int yIndex = (int)d;
            double xRatio = d - (double)yIndex;
            x = this.sideLength * xRatio;
            y = this.sideLength * (double)yIndex / (double)(this.sideNodes - 1);
        }
        return this.getRotatedPointByRectangular(x -= this.halfSideLength, y -= this.halfSideLength);
    }
}

