/*
 * Decompiled with CFR 0.152.
 */
package ow.util;

import java.nio.channels.ClosedByInterruptException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;

public final class Timer
extends TimerTask {
    private static java.util.Timer timer = new java.util.Timer(true);
    private static Map<Thread, TimerTask> timerTable = new HashMap<Thread, TimerTask>();
    private Thread target;
    private boolean oneShot;

    private Timer(Thread target, boolean oneShot) {
        this.target = target;
        this.oneShot = oneShot;
    }

    public static void setTimer(long timeout) {
        Timer.setTimer(timeout, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTimer(long timeout, long interval) {
        boolean oneShot = interval <= 0L;
        Thread curThread = Thread.currentThread();
        Timer task = new Timer(curThread, oneShot);
        Map<Thread, TimerTask> map = timerTable;
        synchronized (map) {
            timerTable.put(curThread, task);
        }
        if (oneShot) {
            timer.schedule((TimerTask)task, timeout);
        } else {
            timer.scheduleAtFixedRate((TimerTask)task, timeout, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTimer() throws InterruptedException, ClosedByInterruptException {
        TimerTask task = null;
        Map<Thread, TimerTask> map = timerTable;
        synchronized (map) {
            task = timerTable.remove(Thread.currentThread());
        }
        if (task != null) {
            task.cancel();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException("Timer#clearTimer() detected current thread has been interrupted.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.target.interrupt();
        Map<Thread, TimerTask> map = timerTable;
        synchronized (map) {
            if (this.oneShot) {
                timerTable.remove(this.target);
            }
        }
    }
}

