/*
 * Decompiled with CFR 0.152.
 */
package ow.ipmulticast;

import java.net.Inet4Address;
import ow.util.Timer;

class Querier {
    private Inet4Address address;
    private int igmpVersion;
    private long respondedTime;

    Querier(Inet4Address address, int igmpVersion) {
        this.address = address;
        this.igmpVersion = igmpVersion;
        this.respondedTime = Timer.currentTimeMillis();
    }

    public Inet4Address getAddress() {
        return this.address;
    }

    public int getIGMPVersion() {
        return this.igmpVersion;
    }

    public int setIGMPVersion(int ver) {
        int old = this.igmpVersion;
        this.igmpVersion = ver;
        return old;
    }

    public long getRespondedTime() {
        return this.respondedTime;
    }

    public long updateRespondedTime() {
        long old = this.respondedTime;
        this.respondedTime = Timer.currentTimeMillis();
        return old;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append(this.address);
        sb.append(":IGMPv");
        sb.append(this.igmpVersion);
        return sb.toString();
    }
}

