/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sdp.SessionDescription;
import javax.sip.SipException;
import javax.sip.address.SipURI;
import jp.ac.naka.ec.EventDispatcher;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityInformation;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.sip.InviteCallback;
import jp.ac.naka.ec.sip.SipCore;

public abstract class AbstractEntity
extends EntityImpl {
    private static EventDispatcher dispatcher = EntityEventDispatcher.getInstance();
    private static SipCore core;
    private static int poolSize;
    private long TTL = 60L;
    private ArrayList<Entity> subscribers = new ArrayList();
    private Map<String, Notifier> notifiers = new HashMap<String, Notifier>();
    private ArrayList<EntityListener> listeners = new ArrayList();
    private ExecutorService ex = Executors.newFixedThreadPool(poolSize);
    private InviteCallback callback;

    static {
        poolSize = 3;
    }

    public AbstractEntity() {
        core = SipCore.getInstance();
        this.addEntityListener(this);
        this.init();
    }

    public AbstractEntity(SipURI uri) {
        super(uri);
        core = SipCore.getInstance();
        this.addEntityListener(this);
        this.init();
    }

    public void init() {
    }

    public final void handleEvent(EntityEvent e) {
        for (EntityListener listener : this.listeners) {
            switch (e.getEventType()) {
                case MESSAGE: {
                    listener.receiveMessage(e);
                    break;
                }
                case NOTIFY: {
                    listener.receiveNotify(e);
                    break;
                }
                case SUBSCRIBE: {
                    listener.receiveSubscribe(e);
                    break;
                }
                case OFFER: {
                    SessionDescription sdp = listener.receiveOffer(e);
                    if (this.callback == null) break;
                    this.callback.receiveAnswer(sdp, e);
                    break;
                }
                case ANSWER: {
                    listener.receiveAnswer(e);
                    break;
                }
                case BYE: {
                    listener.receiveBye(e);
                    break;
                }
                case REMOVE: {
                    listener.expired(e);
                    break;
                }
                case ERROR: {
                    listener.receiveErrorResponse(e);
                }
            }
        }
    }

    public final void addEntityListener(EntityListener listener) {
        this.listeners.add(listener);
    }

    public final boolean removeEntityListener(EntityListener listener) {
        return this.listeners.remove(listener);
    }

    public abstract void receiveMessage(EntityEvent var1);

    public final boolean sendOffer(Entity target) {
        return this.sendOffer(null, target);
    }

    public final boolean sendOffer(SessionDescription sdp, final Entity target) {
        if (!this.isLocal()) {
            return false;
        }
        if (target.isLocal()) {
            EntityEvent e = new EntityEvent(sdp, (EntityListener)target, (Entity)this);
            if (target instanceof AbstractEntity) {
                InviteCallback callback = new InviteCallback(){

                    public void receiveAnswer(SessionDescription sdp, EntityEvent evt) {
                        EntityEvent e = null;
                        if (sdp == null) {
                            throw new NullPointerException("Response Sdp is null");
                        }
                        e = new EntityEvent(sdp, target);
                        AbstractEntity.this.handleEvent(e);
                    }
                };
                ((AbstractEntity)target).setCallback(callback);
                ((AbstractEntity)target).handleEvent(e);
            } else {
                SessionDescription ret = target.receiveOffer(e);
                EntityEvent evt = new EntityEvent(ret, target);
                this.handleEvent(evt);
            }
            return true;
        }
        try {
            core.sendInvite(sdp, target, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public final boolean sendMessage(String msg) {
        EntityContainer target = this.getContainer();
        EntityEvent e = new EntityEvent(msg, (EntityListener)target, (Entity)this);
        for (Entity s : this.subscribers) {
            try {
                core.sendRequest(msg, s, this, "MESSAGE");
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return false;
            }
        }
        dispatcher.dispatchEvent(e);
        return true;
    }

    public final boolean sendMessage(String msg, Entity target) {
        if (target.isLocal()) {
            EntityEvent e = new EntityEvent(msg, (EntityListener)target, (Entity)this);
            target.receiveMessage(e);
        } else {
            try {
                core.sendRequest(msg, target, this, "MESSAGE");
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public final boolean sendBye(Entity target) {
        if (!this.isLocal()) {
            return false;
        }
        EntityEvent evt = new EntityEvent(target, this, EntityEvent.EventType.BYE);
        if (target.isLocal()) {
            if (target instanceof AbstractEntity) {
                ((AbstractEntity)target).handleEvent(evt);
            } else {
                target.receiveBye(evt);
            }
        } else {
            try {
                core.sendBye(target);
            }
            catch (SipException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public final boolean subscribe(Entity target) {
        return this.subscribe(target, 60);
    }

    public final boolean subscribe(Entity target, int expires) {
        if (!this.isLocal()) {
            return false;
        }
        if (target.isLocal()) {
            EntityEvent evt = new EntityEvent(target, this, EntityEvent.EventType.SUBSCRIBE);
            target.receiveSubscribe(evt);
        } else {
            try {
                Notifier notifier = new Notifier(target, this, expires);
                this.ex.execute(notifier);
                this.notifiers.put(target.getURI().toString(), notifier);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public final boolean unsubscribe(Entity target) {
        Notifier notifier = this.notifiers.get(target.getURI().toString());
        if (notifier == null) {
            return false;
        }
        try {
            notifier.sendUnsubscribe();
        }
        catch (SipException e) {
            e.printStackTrace();
            return false;
        }
        this.notifiers.remove(target.getURI().toString());
        notifier = null;
        return true;
    }

    public final void addSubscriber(Entity entity) {
        this.subscribers.add(entity);
    }

    public final void removeSubscriber(Entity entity) {
        this.subscribers.remove(entity);
    }

    public void setCallback(InviteCallback callback) {
        this.callback = callback;
    }

    public InviteCallback getCallback() {
        return this.callback;
    }

    public void startNotify(final Entity target) {
        final AbstractEntity source = this;
        Runnable th = new Runnable(){

            public void run() {
                do {
                    System.out.println("notify to " + target);
                    EntityInformation info = new EntityInformation(source);
                    try {
                        core.sendRequest(info.toXML(), target, source, "NOTIFY");
                        Thread.sleep(AbstractEntity.this.TTL * 1000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                } while (AbstractEntity.this.subscribers.contains(target));
            }
        };
        this.ex.execute(th);
    }

    public final long getTTL() {
        return this.TTL;
    }

    public final void setTTL(long ttl) {
        this.TTL = ttl;
    }

    final class Notifier
    extends EntityImpl
    implements Runnable {
        private Entity target;
        private Entity source;
        private boolean run;
        int expires;

        public Notifier(Entity target, Entity source) {
            super(target.getURI());
            this.run = true;
            this.expires = 60;
            this.target = target;
            this.source = source;
        }

        public Notifier(Entity target, Entity source, int expires) {
            this(target, source);
            this.expires = expires;
        }

        public void run() {
            try {
                while (this.run) {
                    core.sendSubscribe(this.target, this.source, this.expires);
                    Thread.sleep(this.expires * 1000 - 1000);
                }
            }
            catch (SipException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void sendUnsubscribe() throws SipException {
            this.run = false;
            core.sendSubscribe(this.target, this.source, 0);
        }
    }
}

