/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity.test;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.UnknownHostException;
import javax.sdp.SdpException;
import javax.sdp.SessionDescription;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.ac.naka.ec.EntityCollaborator;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.media.AudioPlayer;

public class PhoneEntity
extends AbstractEntity {
    Entity callee;
    AudioPlayer ap;
    ButtonFrame button;
    JTextField field = new JTextField("audio_transmitter");
    static String path = "file:///Users/kasuya/workspace/EntityCollaborator_DHT/media/B5_01002.AIF";
    int port = 22224;

    public PhoneEntity() {
        this.setEntityType(EntityType.MEDIA_RECEIVER);
        this.addKeyword("audio_receiver");
        this.ap = new AudioPlayer();
        this.button = new ButtonFrame("Audio Receiver");
    }

    public void receiveMessage(EntityEvent e) {
        System.out.println("From : " + e.getSource());
        System.out.print("\t" + e.getMessage());
        this.sendMessage("Hello!", (Entity)e.getSource());
    }

    public void receiveAnswer(EntityEvent evt) {
        SessionDescription sdp = evt.getSessionDescription();
        try {
            System.out.println("start");
            this.ap.receiveMediaStream(this.port);
            if (path != null) {
                this.ap.sendMediaStream(sdp);
            } else {
                this.ap.sendMediaStream(path, sdp);
            }
            Component comp = this.ap.getReceiverController();
            this.button.add(comp);
            this.button.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void requestMedia() {
        if (this.callee != null) {
            return;
        }
        EntityCollaborator con = EntityCollaborator.getInstance();
        Entity[] set = null;
        SessionDescription sdp = null;
        set = con.searchEntities(this.field.getText());
        try {
            sdp = this.ap.getRequestSessionDescription(this);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SdpException e) {
            e.printStackTrace();
        }
        Entity[] entityArray = set;
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (entity.getEntityType() == EntityType.MEDIA_TRANSMITTER || entity.getEntityType() == EntityType.SOUND) {
                this.sendOffer(sdp, entity);
                this.callee = entity;
                break;
            }
            ++n2;
        }
    }

    public void receiveBye(EntityEvent e) {
        System.out.println("Receive Bye");
        if (this.ap.isPlaying()) {
            this.ap.stopReceivingMediaStream();
            this.ap.stopSendingMediaStream();
        }
        this.callee = null;
    }

    public static void main(String[] args) {
        if (args.length >= 1) {
            path = args[0];
        }
        try {
            EntityCollaborator ec = EntityCollaborator.getInstance();
            ec.initiateSipCore();
            ec.initiateDHT();
            ec.addEntity(new PhoneEntity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ButtonFrame
    extends JFrame {
        JButton jb;
        JButton bye;
        JPanel panel;

        public ButtonFrame(String name) {
            super(name);
            this.jb = new JButton("Request Media!");
            this.bye = new JButton("BYE");
            this.panel = new JPanel();
            this.panel.add(this.jb);
            this.panel.add(this.bye);
            this.setLayout(new GridLayout(0, 1));
            this.jb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PhoneEntity.this.requestMedia();
                }
            });
            this.bye.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (((ButtonFrame)ButtonFrame.this).PhoneEntity.this.callee != null) {
                        PhoneEntity.this.sendBye(((ButtonFrame)ButtonFrame.this).PhoneEntity.this.callee);
                        ((ButtonFrame)ButtonFrame.this).PhoneEntity.this.ap.stopReceivingMediaStream();
                        ((ButtonFrame)ButtonFrame.this).PhoneEntity.this.ap.stopSendingMediaStream();
                        ((ButtonFrame)ButtonFrame.this).PhoneEntity.this.callee = null;
                        System.out.println("end");
                    }
                }
            });
            this.add(PhoneEntity.this.field);
            this.add(this.panel);
            this.pack();
            this.setDefaultCloseOperation(3);
            this.setVisible(true);
        }
    }
}

