/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sensor;

import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.sensor.Device;
import jp.ac.naka.ec.sensor.SensorData;

public class SensorDataImpl
implements SensorData {
    String id;
    Location loc;
    Device device;
    long ttl = 60L;
    String measure;
    SensorData.DataType type = SensorData.DataType.String;
    String data;
    String dataName;

    public Device getDevice() {
        return this.device;
    }

    public String getName() {
        return this.id;
    }

    public Location getLocation() {
        return this.loc;
    }

    public long getTTL() {
        return this.ttl;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public void setName(String id) {
        this.id = id;
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }

    public void setTTL(long ttl) {
        this.ttl = ttl;
    }

    public SensorData.DataType getDataType() {
        return this.type;
    }

    public void setDataType(SensorData.DataType dataType) {
        if (dataType == null) {
            return;
        }
        this.type = dataType;
    }

    public String getMeasure() {
        return this.measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public CharSequence toXML() {
        return this.toXML("");
    }

    public CharSequence toXML(String padding) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.addPadding("<sensor name=\"", padding));
        sb.append(this.id);
        sb.append("\" ttl=\"");
        sb.append(this.ttl);
        sb.append("\">\r\n");
        if (this.device != null) {
            sb.append(this.addPadding(this.device.toXML(padding), String.valueOf(padding) + "\t"));
        } else {
            sb.append(this.addPadding("\t<device />\r\n", padding));
        }
        if (this.loc != null) {
            sb.append(this.loc.toXML(String.valueOf(padding) + "\t"));
        }
        sb.append(this.addPadding("\t<data ", padding));
        if (this.dataName != null) {
            sb.append(" name=\"");
            sb.append(this.dataName);
            sb.append("\" ");
        }
        sb.append("type=\"");
        sb.append(this.type != null ? this.type.toString() : "Unknown");
        sb.append("\" measure=\"");
        sb.append(this.measure != null ? this.measure : "");
        sb.append("\">");
        sb.append(this.data);
        sb.append("</data>\r\n");
        sb.append(padding);
        sb.append("</sensor>\r\n");
        return sb.toString();
    }

    private String addPadding(String str, String padding) {
        return String.valueOf(padding) + str;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Object getData() {
        if (this.type == null || this.data == null) {
            return this.data;
        }
        Object ret = null;
        try {
            switch (this.type) {
                case Integer: {
                    ret = Integer.valueOf(this.data);
                    break;
                }
                case Float: {
                    ret = Float.valueOf(this.data);
                    break;
                }
                case Double: {
                    ret = Double.valueOf(this.data);
                    break;
                }
                case String: {
                    ret = this.data;
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void main(String[] args) {
        SensorDataImpl s = new SensorDataImpl();
        s.setName("hoge");
        s.setDataName("moxa");
        s.setDataType(SensorData.DataType.Float);
        s.setData("10");
        s.setLocation(new Location("hogehoge", "20.0", "30.0"));
        System.out.println(s.toXML());
    }

    public String getDataName() {
        return this.dataName;
    }

    public void setDataName(String dataName) {
        this.dataName = dataName;
    }
}

