/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.sip.RequestEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.ContactHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import jp.ac.naka.ec.EntityCollaborator;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.entity.test.ButtonEntity;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RegisterDelegate
implements MethodDelegate {
    private static Log logger = LogFactory.getLog(RegisterDelegate.class);
    private static SipCore core;
    private HashMap<String, Timer> clients = new HashMap();

    public RegisterDelegate() {
        core = SipCore.getInstance();
    }

    public boolean forward(RequestEvent evt) {
        Request req = evt.getRequest();
        ToHeader to = (ToHeader)req.getHeader("To");
        ContactHeader contact = (ContactHeader)req.getHeader("Contact");
        Address target = to.getAddress();
        SipURI targetURI = (SipURI)target.getURI();
        SipURI contactURI = (SipURI)contact.getAddress().getURI();
        SipClient temp = (SipClient)this.clients.get(targetURI.toString());
        if (temp != null) {
            logger.info((Object)("Reflesh : " + targetURI));
            temp.reflesh();
            try {
                core.sendResponse(200, evt, contactURI.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        ExpiresHeader expiresHeader = (ExpiresHeader)req.getHeader("Expires");
        int expires = expiresHeader.getExpires();
        AbstractEntity source = new AbstractEntity(targetURI){

            public void receiveMessage(EntityEvent e) {
            }
        };
        source.setLocal(false);
        source.setContactURI(contactURI);
        source.addKeyword(target.getDisplayName());
        if (expiresHeader == null) {
            this.expiresOut(source);
            return true;
        }
        source.setEntityType(EntityType.SOUND);
        EntityCollaborator.getInstance().addEntity(source);
        this.clients.put(contactURI.toString(), new SipClient(source, expires));
        try {
            core.sendResponse(200, evt, target.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void expiresOut(Entity entity) {
        SipURI uri = entity.getURI();
        if (!this.clients.containsKey(uri.toString())) {
            throw new NullPointerException("SipClient : " + uri + " is null.");
        }
        this.clients.remove(uri);
        EntityCollaborator.getInstance().removeEntity(entity);
        entity = null;
        logger.info((Object)("Remove Client :" + uri));
    }

    public static void main(String[] args) {
        String str = "REGISTER sip:10.0.1.221 SIP/2.0\r\nVia: SIP/2.0/UDP 10.0.1.221:20510;branch=z9hG4bK-d87543-6d9b272834735003-1--d87543-;rport=20510;received=10.0.1.221\r\nMax-Forwards: 70\r\nContact: <sip:201@192.168.0.20:20510;rinstance=204379f79bef1d2c>To: \"201\" <sip:201@192.168.0.20>\r\nFrom: \"201\" <sip:201@192.168.0.20>;tag=5e8e37ab\r\nCall-ID: NTg0MGE4Njk3MmJmOTk3YWZiNzc3NWZlMmM1MTc5OTk.\r\nCSeq: 1 REGISTER\r\nExpires: 60\r\nAllow: INVITE,ACK,CANCEL,OPTIONS,BYE,REFER,NOTIFY,MESSAGE,SUBSCRIBE,INFO\r\nUser-Agent: X-Lite/release/1011b/stamp/39984\r\nContent-Length: 0\r\n\r\n";
        try {
            EntityCollaborator ec = EntityCollaborator.getInstance("lo0");
            ec.initiateSipCore();
            ec.initiateDHT();
            ec.addEntity(new ButtonEntity());
            Thread.sleep(1000L);
            byte[] buf = str.getBytes();
            DatagramSocket socket = new DatagramSocket();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, InetAddress.getByName("10.0.1.221"), 5060);
            socket.send(packet);
            System.out.println("\"" + new String(buf) + "\"\u3092\u9001\u4fe1\u3057\u307e\u3057\u305f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class SipClient
    extends Timer {
        int expires = 3600;
        TimerTask task;

        public SipClient(final Entity source, int expires) {
            this.expires = expires;
            this.task = new TimerTask(){

                public void run() {
                    RegisterDelegate.this.expiresOut(source);
                }
            };
            this.start();
        }

        public void start() {
            this.schedule(this.task, this.expires * 1000);
        }

        public void reflesh() {
            this.cancel();
            this.start();
        }
    }
}

