/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip.pidf;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.sip.address.URI;

public class Tuple {
    public String id = "";
    public Status status = new Status();
    private float priority = 100.0f;
    private boolean alive = true;
    List<String> notes;
    Hashtable<String, String> extension;
    public URI contact;
    public String timestamp;

    public void addNote(String note) {
        if (note == null) {
            return;
        }
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(note);
    }

    public boolean isAlived() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public String toString() {
        StringBuilder stBuffer = new StringBuilder();
        stBuffer.append(this.status.toString());
        if (this.extension != null) {
            Enumeration<String> keys = this.extension.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = this.extension.get(key);
                stBuffer.append("<" + key + ">");
                stBuffer.append(value);
                stBuffer.append("</" + key + ">\r\n");
            }
        }
        if (this.contact != null) {
            if (this.priority == 100.0f) {
                stBuffer.append("<contact>");
            } else {
                stBuffer.append("<contact priority=");
                stBuffer.append('\"');
                stBuffer.append(this.priority);
                stBuffer.append('\"');
                stBuffer.append(">");
            }
            stBuffer.append(this.contact.toString());
            stBuffer.append("</contact>\r\n");
        }
        if (this.notes != null) {
            for (String note : this.notes) {
                stBuffer.append("<note>");
                stBuffer.append(note);
                stBuffer.append("</note>\r\n");
            }
        }
        if (this.timestamp != null && !this.timestamp.equals("")) {
            stBuffer.append("<timestamp>");
            stBuffer.append(this.timestamp);
            stBuffer.append("</timestamp>\r\n");
        }
        return stBuffer.toString();
    }

    public void putExtension(String key, Object obj) {
        if (this.extension == null) {
            this.extension = new Hashtable();
        }
        this.extension.put(key, obj.toString());
    }

    public Object getExtension(String key) {
        if (this.extension == null) {
            throw new NullPointerException("Extension is null!");
        }
        return this.extension.get(key);
    }

    public float getPriority() {
        return this.priority;
    }

    public void setPriority(float priority) {
        if (priority < 0.0f || priority > 1.0f) {
            System.err.println("Priority must be between 0.0 to 1.0.");
            return;
        }
        this.priority = priority;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Basic {
        OPEN,
        CLOSE;

    }

    class Status {
        Basic basic = Basic.OPEN;

        Status() {
        }

        public String toString() {
            StringBuilder stBuffer = new StringBuilder();
            stBuffer.append("<status>\r\n\t");
            stBuffer.append("<alive>");
            String value = Tuple.this.alive ? "YES" : "NO";
            stBuffer.append(value);
            stBuffer.append("</alive>");
            stBuffer.append("</status>\r\n");
            return stBuffer.toString();
        }
    }
}

