/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity.test;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import jp.ac.naka.ec.EntityCollaborator;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;

/**
 * Cxg\邾EntityBeXgpB
 * @author Takashi Kasuya
 *
 */
public class MessangerEntity extends AbstractEntity {

	JTextArea area;
	JFrame frame;
	JComboBox box;
	
	public MessangerEntity() {
		// L[[hݒ
		addKeyword("205");
		// SwingR|[lgݒ
		frame = new JFrame("Messanger");
		area = new JTextArea(30,20);
		frame.add(new JScrollPane(area), BorderLayout.CENTER);
		JPanel panel = new JPanel();
		final JTextField field = new JTextField(25);
		JButton button = new JButton("Send");
		final Entity source = this;
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				String msg = field.getText();
				field.setText("");
				// M镶̕\
				StringBuilder st = new StringBuilder();
				st.append(area.getText());
				st.append(source.getURI().getUser()+ " : " + msg +  "\n");				
				area.setText(st.toString());
				// IĂEntity̎擾
				Entity selected = (Entity)box.getSelectedItem();
				if (selected != null);
					sendMessage(msg, selected);
			}
		});
		panel.add(field);
		panel.add(button);
		frame.add(panel, BorderLayout.SOUTH);
		// Combobox̐ݒ
		final DefaultComboBoxModel model = new DefaultComboBoxModel();
		box = new JComboBox(model);
		frame.add(box, BorderLayout.NORTH);
		// Combobox̒XV
		Thread th = new Thread() {
			public void run() {
				while(true) {
				Entity[] entities = EntityCollaborator.getInstance().getEntities();
				model.removeAllElements();
				for (Entity entity:entities)
					model.addElement(entity);
					// 5bɍXV
					try {
						sleep(5000);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
		};
		th.start();
		frame.pack();
		frame.setVisible(true);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}


	@Override
	public void receiveMessage(EntityEvent e) {
		StringBuilder st = new StringBuilder();
		st.append(area.getText());
		// M̎擾
		String msg = e.getMessage() ;
		// M̎擾
		Entity source = (Entity)e.getSource();
		st.append(source.getURI().getUser()+ " : " + msg +  "\n");
		// M̕\
		area.setText(st.toString());
	}
	
	public static void main(String[] args) {
		try {
			// tgGh̎擾Cݒ
			EntityCollaborator ec = EntityCollaborator.getInstance();
			ec.initiateSipCore();
			ec.initiateDHT();
			ec.addEntity(new MessangerEntity());
		} catch (Exception e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
	}
}
