angular.module('zephyrApp')
.controller('CreateFileModalCtrl', function ($scope, $modalInstance,$upload, $location, api) {

    $scope.create = function () {
        $modalInstance.close();
    };

    $scope.cancel      = function() {
        $modalInstance.close();
    };

    var dir = $location.path().replace("/workspacePage/","");

    $scope.fileSelected = function($files, $event) {
        $scope.files = $files;
    };

    $scope.submit = function() {
        if ($scope.files) {
            console.log($scope.files);
        } else {
            alert("Select Files.");
        }
        angular.forEach($scope.files, function (file) {
            $upload.upload({
                url: 'api/upload/create/' + dir, 
                method: 'POST',
                headers: {'Authorization': 'xxx'}, // only for html5
                withCredentials: true,
                file: file 
            }).progress(function(evt) {
                console.log('progress: ' + parseInt(100.0 * evt.loaded / evt.total) + '% file :'+ evt.config.file.name);
            }).success(function(data, status, headers, config) {
                console.log('file ' + config.file.name + 'is uploaded successfully. Response: ' + data);
            });
        });
        
        $scope.update();
        $modalInstance.close();
    };
});
