/**
 * Main application routes
 */

'use strict';

var errors = require('./components/errors');

module.exports = function(app) {

  // Insert routes below
  app.use('/api/upload', require('./api/upload'));
  app.use('/api/workspace', require('./api/workspace'));
  app.use('/api/option', require('./api/option'));
  app.use('/api/tagList', require('./api/tagList'));
  app.use('/api/commandList', require('./api/commandList'));
  
  // All undefined asset or api routes should return a 404
  app.route('/:url(api|auth|components|app|bower_components|assets)/*')
   .get(errors[404]);

  // All other routes should redirect to the index.html
  app.route('/*')
    .get(function(req, res) {
      res.sendfile(app.get('appPath') + '/index.html');
    });
};
