/*
# eosBayesInit : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : eosBayesInit
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "String.h"
#include "eosBayes.h"

/*
Example:
typedef struct leosBayesInitInfo {
	float a;
	int   b;
} leosBayesInitInfo;

typedef enum leosBayesInitMode {
	a=0,
	b=1
} leosBayesInitMode;
*/

int
main(int argc, char* argv[]) 
{
	eosBayes out;
	eosBayesInitInfo info;
	eosBayesDistributionInfo llinfo;
	int i;
	char s[1024];
	
	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	DEBUGPRINT("Program Start\n");

	eosBayesInit(&out, info.numDistribution, info.numLikelihood, info.mode);

	// input: info.fptIn  
	// 0 min0 max0 delta0 mode0 mean0 sigma0
	// ... 
	for(i=0; i<info.numDistribution; i++) {
		// read each of min, max, delta, mode, mean, sigma

		stringGetFromFile(s, "in main", info.fptIn, stdout, 0);
		llinfo.min = stringGetNthRealData(s, 2, " \t");
		llinfo.max = stringGetNthReadData(s, 3, " \t");
		//llinfo.delta = delta;
		llinfo.mode  = stringGetNthIntegerData(s, 5, " \t");
		//llinfo.mean = mean;
		//llinfo.sigma = sigma;
		eosBayesDistributionInit(&(out.prior[i]), &llinfo, info.mode) 
		eosBayesDistributionInitialProbabilitySet(eosBayesDistribution* d, &llinfo, info.mode);
	}

	eosBayesPriorWrite(info.Out, &out, info.mode); 

	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
}
