/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% eosBayesDistributionInitialProbabilitySet ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : eosBayesDistributionInitialProbabilitySet 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%eosBayesDistributionInitialProbabilitySet ver%I%; Date:%D% %Z%";


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "../inc/eosBayes.h"


void eosBayesDistributionInitialProbabilitySet(eosBayesDistribution* d, eosBayesDistributionInfo* info, int mode){

	int i;
	float data;
	float sum;

	switch(info->mode){

		case eosBayesDistributionInfoModeGaussian:
			fprintf(stderr, "-----Mode Gaussian distribution-----\n");
			sum = 0;
			for(i=0;i<d->n;i++){
				data       = info->min + (info->delta*i);
				d->prob[i] = (1/sqrt(2*M_PI*info->sigma*info->sigma))*exp(-(((data-info->mean)*(data-info->mean))/(2*info->sigma*info->sigma)));
				sum += d->prob[i];
			}
			
			for(i=0;i<d->n;i++){
				d->prob[i] /= sum;
			}

			break;

		default:
			break;

	}
}
