/*
# ctfDeterminationByBayes : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : ctfDeterminationByBayes
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"
#include "eosBayes.h"
#include "ctfInfo.h"
#include "ctffuncforbayes.h"


#define DEBUG
#include "genUtil.h"
#include "ctfDeterminationByBayes.h"
#include "String.h"

/*
Example:
typedef struct lctfDeterminationByBayesInfo {
	float a;
	int   b;
} lctfDeterminationByBayesInfo;

typedef enum lctfDeterminationByBayesMode {
	a=0,
	b=1
} lctfDeterminationByBayesMode;
*/

int
main(int argc, char* argv[]) 
{
  
  ctfDeterminationByBayesInfo info;
  ctfInfo ctfinfo;
  eosBayesDistributionInfo llinfo;
  
  eosBayes out;
  ctfforbayes ctf;
  intensityforbayes intensity;

  int i;

  init0(&info);
  argCheck(&info, argc, argv);
  init1(&info);

  DEBUGPRINT("Program Start\n");

  ctfinfo.mode = 33;


  leosBayesInit(&out, info.numDistribution, info.numLikelihood, info.mode);
  eosBayesCondition(info.fptIn, &out, &llinfo, 0);
  eosBayesPriorWrite(info.fptOut2, &out,0);
  DistributionChangeCheck(&out, 0);


  ctfforbayesInit(info.fptIn2,&ctf,0);
  intensityforbayesInit(&intensity,info.flagIn4,ctf.n);
  spatialfrequencyRead(info.fptIn2,&ctf,info.rmax,info.rmin,0);

  for(i=0;i<info.flagIn4;i++){
	intensityRead(info.In4[i],&intensity,i,0);
  }

  ctfInfoRead(info.fptIn3,&ctfinfo,"",0);
  DEBUGPRINT4("kV:%f  Cs:%f  Ain:%f ctfMode:%ld\n",ctfinfo.kV,ctfinfo.Cs,ctfinfo.Ain,ctfinfo.mode);
  DEBUGPRINT1("flagIn4:%ld\n",info.flagIn4);

  DEBUGPRINT("ctf start\n");
  DEBUGPRINT("----ctfmode 1----\n");
  ctfFunctionforbayes(&ctf, &intensity,out.likelihood,&ctfinfo,out.numLikelihood,i,1);


  /*defocus estimation*/
  for(i=0;i<info.flagIn4;i++){
	
	DEBUGPRINT("set intensity\n");
	intensitySet(&ctf,intensity,i,0);
	

	DEBUGPRINT("likelihood start\n");
	defocuslikelihood(ctf,&out,i,0);
	LikelihoodChangeCheck(&out,i,0);

	DEBUGPRINT("estimate start\n");
	eosBayesEstimation(&out,0);

	DistributionChangeCheck(&out,1);
	  
	DEBUGPRINT("change start\n");
	eosBayesPosteriortoPrior(&out,0);
	DEBUGPRINT("loop end\n");

  }
  
  eosBayesPriorWrite(info.fptOut,&out,0);
  
  exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
  fprintf(stderr, "----- Additional Usage -----\n");
}

