<?php
// vim: foldmethod=marker
/**
 *  Ethna_Plugin_Validator_Regexp.php
 *
 *  @author     ICHII Takashi <ichii386@schweetheart.jp>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: Ethna_Plugin_Validator_Regexp.php 318 2006-08-11 10:26:00Z ichii386 $
 */

// {{{ Ethna_Plugin_Validator_Regexp
/**
 *  ɽˤХǡץ饰
 *
 *  @author     ICHII Takashi <ichii386@schweetheart.jp>
 *  @access     public
 *  @package    Ethna
 */
class Ethna_Plugin_Validator_Regexp extends Ethna_Plugin_Validator
{
    /** @var    bool    뤫ե饰 */
    var $accept_array = false;

    /**
     *  ɽˤեͤΥåԤ
     *
     *  @access public
     *  @param  string  $name       ե̾
     *  @param  mixed   $var        ե
     *  @param  array   $params     ץ饰Υѥ᡼
     */
    function &validate($name, $var, $params)
    {
        $true = true;
        $type = $this->getFormType($name);
        if (isset($params['regexp']) == false
            || $type == VAR_TYPE_FILE || $this->isEmpty($var, $type)) {
            return $true;
        }

        if (preg_match($params['regexp'], $var) == 0) {
            if (isset($params['error'])) {
                $msg = $params['error'];
            } else {
                $msg = "{form}ϤƤ";
            }
            return Ethna::raiseNotice($msg, E_FORM_REGEXP);
        }

        return $true;
    }
}
// }}}
?>
