/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package com.evernote.edam.type;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import com.evernote.edam.util.BitSet;
import java.util.Arrays;

import org.apache.thrift.*;
import org.apache.thrift.meta_data.*;
import org.apache.thrift.protocol.*;

/**
 *  This represents the bookkeeping information for the user's subscription.
 *  
 * <dl>
 *  <dt>uploadLimit</dt>
 *    <dd>The number of bytes that can be uploaded to the account
 *    in the current month.  For new notes that are created, this is the length
 *    of the note content (in Unicode characters) plus the size of each resource
 *    (in bytes).  For edited notes, this is the the difference between the old
 *    length and the new length (if this is greater than 0) plus the size of
 *    each new resource.
 *    </dd>
 *  <dt>uploadLimitEnd</dt>
 *    <dd>The date and time when the current upload limit
 *    expires.  At this time, the monthly upload count reverts to 0 and a new
 *    limit is imposed.  This date and time is exclusive, so this is effectively
 *    the start of the new month.
 *    </dd>
 *  <dt>uploadLimitNextMonth</dt>
 *    <dd> When uploadLimitEnd is research the service
 *    will change uploadLimit to uploadLimitNextMonth. If a premium account is
 *    canceled, this mechanism will reset the quota appropriately.
 *    </dd>
 *  <dt>premiumServiceStatus</dt>
 *    <dd>Indicates the phases of a premium account
 *    during the billing process.
 *    </dd>
 *  <dt>premiumOrderNumber</dt>
 *    <dd>The order number used by the commerce system to
 *    process recurring payments
 *    </dd>
 *  <dt>premiumServiceStart</dt>
 *    <dd>The start date when this premium promotion
 *    began (this number will get overwritten if a premium service is canceled
 *    and then re-activated).
 *    </dd>
 *  <dt>premiumCommerceService</dt>
 *    <dd>The commerce system used (paypal, Google
 *    checkout, etc)
 *    </dd>
 *  <dt>premiumServiceSKU</dt>
 *    <dd>The code associated with the purchase eg. monthly
 *    or annual purchase. Clients should interpret this value and localize it.
 *    </dd>
 *  <dt>lastSuccessfulCharge</dt>
 *    <dd>Date the last time the user was charged.
 *    Null if never charged.
 *    </dd>
 *  <dt>lastFailedCharge</dt>
 *    <dd>Date the last time a charge was attempted and
 *    failed.
 *    </dd>
 *  <dt>lastFailedChargeReason</dt>
 *    <dd>Reason provided for the charge failure
 *    </dd>
 *  <dt>nextPaymentDue</dt>
 *    <dd>The end of the billing cycle. This could be in the
 *    past if there are failed charges.
 *    </dd>
 *  <dt>premiumLockUntil</dt>
 *    <dd>An internal variable to manage locking operations
 *    on the commerce variables.
 *    </dd>
 *  <dt>updated</dt>
 *    <dd>The date any modification where made to this record.
 *    </dd>
 *  <dt>premiumSubscriptionNumber</dt>
 *    <dd>The number number identifying the
 *    recurring subscription used to make the recurring charges.
 *    </dd>
 *  </dl>
 */
public class Accounting implements TBase<Accounting._Fields>, java.io.Serializable, Cloneable, Comparable<Accounting> {
  private static final TStruct STRUCT_DESC = new TStruct("Accounting");

  private static final TField UPLOAD_LIMIT_FIELD_DESC = new TField("uploadLimit", TType.I64, (short)1);
  private static final TField UPLOAD_LIMIT_END_FIELD_DESC = new TField("uploadLimitEnd", TType.I64, (short)2);
  private static final TField UPLOAD_LIMIT_NEXT_MONTH_FIELD_DESC = new TField("uploadLimitNextMonth", TType.I64, (short)3);
  private static final TField PREMIUM_SERVICE_STATUS_FIELD_DESC = new TField("premiumServiceStatus", TType.I32, (short)4);
  private static final TField PREMIUM_ORDER_NUMBER_FIELD_DESC = new TField("premiumOrderNumber", TType.STRING, (short)5);
  private static final TField PREMIUM_COMMERCE_SERVICE_FIELD_DESC = new TField("premiumCommerceService", TType.STRING, (short)6);
  private static final TField PREMIUM_SERVICE_START_FIELD_DESC = new TField("premiumServiceStart", TType.I64, (short)7);
  private static final TField PREMIUM_SERVICE_SKU_FIELD_DESC = new TField("premiumServiceSKU", TType.STRING, (short)8);
  private static final TField LAST_SUCCESSFUL_CHARGE_FIELD_DESC = new TField("lastSuccessfulCharge", TType.I64, (short)9);
  private static final TField LAST_FAILED_CHARGE_FIELD_DESC = new TField("lastFailedCharge", TType.I64, (short)10);
  private static final TField LAST_FAILED_CHARGE_REASON_FIELD_DESC = new TField("lastFailedChargeReason", TType.STRING, (short)11);
  private static final TField NEXT_PAYMENT_DUE_FIELD_DESC = new TField("nextPaymentDue", TType.I64, (short)12);
  private static final TField PREMIUM_LOCK_UNTIL_FIELD_DESC = new TField("premiumLockUntil", TType.I64, (short)13);
  private static final TField UPDATED_FIELD_DESC = new TField("updated", TType.I64, (short)14);
  private static final TField PREMIUM_SUBSCRIPTION_NUMBER_FIELD_DESC = new TField("premiumSubscriptionNumber", TType.STRING, (short)16);
  private static final TField LAST_REQUESTED_CHARGE_FIELD_DESC = new TField("lastRequestedCharge", TType.I64, (short)17);

  private long uploadLimit;
  private long uploadLimitEnd;
  private long uploadLimitNextMonth;
  private PremiumOrderStatus premiumServiceStatus;
  private String premiumOrderNumber;
  private String premiumCommerceService;
  private long premiumServiceStart;
  private String premiumServiceSKU;
  private long lastSuccessfulCharge;
  private long lastFailedCharge;
  private String lastFailedChargeReason;
  private long nextPaymentDue;
  private long premiumLockUntil;
  private long updated;
  private String premiumSubscriptionNumber;
  private long lastRequestedCharge;

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements TFieldIdEnum {
    UPLOAD_LIMIT((short)1, "uploadLimit"),
    UPLOAD_LIMIT_END((short)2, "uploadLimitEnd"),
    UPLOAD_LIMIT_NEXT_MONTH((short)3, "uploadLimitNextMonth"),
    /**
     * 
     * @see PremiumOrderStatus
     */
    PREMIUM_SERVICE_STATUS((short)4, "premiumServiceStatus"),
    PREMIUM_ORDER_NUMBER((short)5, "premiumOrderNumber"),
    PREMIUM_COMMERCE_SERVICE((short)6, "premiumCommerceService"),
    PREMIUM_SERVICE_START((short)7, "premiumServiceStart"),
    PREMIUM_SERVICE_SKU((short)8, "premiumServiceSKU"),
    LAST_SUCCESSFUL_CHARGE((short)9, "lastSuccessfulCharge"),
    LAST_FAILED_CHARGE((short)10, "lastFailedCharge"),
    LAST_FAILED_CHARGE_REASON((short)11, "lastFailedChargeReason"),
    NEXT_PAYMENT_DUE((short)12, "nextPaymentDue"),
    PREMIUM_LOCK_UNTIL((short)13, "premiumLockUntil"),
    UPDATED((short)14, "updated"),
    PREMIUM_SUBSCRIPTION_NUMBER((short)16, "premiumSubscriptionNumber"),
    LAST_REQUESTED_CHARGE((short)17, "lastRequestedCharge");

    private static final Map<Integer, _Fields> byId = new HashMap<Integer, _Fields>();
    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byId.put((int)field._thriftId, field);
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      return byId.get(fieldId);
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __UPLOADLIMIT_ISSET_ID = 0;
  private static final int __UPLOADLIMITEND_ISSET_ID = 1;
  private static final int __UPLOADLIMITNEXTMONTH_ISSET_ID = 2;
  private static final int __PREMIUMSERVICESTART_ISSET_ID = 3;
  private static final int __LASTSUCCESSFULCHARGE_ISSET_ID = 4;
  private static final int __LASTFAILEDCHARGE_ISSET_ID = 5;
  private static final int __NEXTPAYMENTDUE_ISSET_ID = 6;
  private static final int __PREMIUMLOCKUNTIL_ISSET_ID = 7;
  private static final int __UPDATED_ISSET_ID = 8;
  private static final int __LASTREQUESTEDCHARGE_ISSET_ID = 9;
  private BitSet __isset_bit_vector = new BitSet(10);

  public static final Map<_Fields, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new EnumMap<_Fields, FieldMetaData>(_Fields.class) {{
    put(_Fields.UPLOAD_LIMIT, new FieldMetaData("uploadLimit", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.UPLOAD_LIMIT_END, new FieldMetaData("uploadLimitEnd", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.UPLOAD_LIMIT_NEXT_MONTH, new FieldMetaData("uploadLimitNextMonth", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.PREMIUM_SERVICE_STATUS, new FieldMetaData("premiumServiceStatus", TFieldRequirementType.OPTIONAL, 
        new EnumMetaData(TType.ENUM, PremiumOrderStatus.class)));
    put(_Fields.PREMIUM_ORDER_NUMBER, new FieldMetaData("premiumOrderNumber", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.PREMIUM_COMMERCE_SERVICE, new FieldMetaData("premiumCommerceService", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.PREMIUM_SERVICE_START, new FieldMetaData("premiumServiceStart", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.PREMIUM_SERVICE_SKU, new FieldMetaData("premiumServiceSKU", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.LAST_SUCCESSFUL_CHARGE, new FieldMetaData("lastSuccessfulCharge", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.LAST_FAILED_CHARGE, new FieldMetaData("lastFailedCharge", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.LAST_FAILED_CHARGE_REASON, new FieldMetaData("lastFailedChargeReason", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.NEXT_PAYMENT_DUE, new FieldMetaData("nextPaymentDue", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.PREMIUM_LOCK_UNTIL, new FieldMetaData("premiumLockUntil", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.UPDATED, new FieldMetaData("updated", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
    put(_Fields.PREMIUM_SUBSCRIPTION_NUMBER, new FieldMetaData("premiumSubscriptionNumber", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.STRING)));
    put(_Fields.LAST_REQUESTED_CHARGE, new FieldMetaData("lastRequestedCharge", TFieldRequirementType.OPTIONAL, 
        new FieldValueMetaData(TType.I64)));
  }});

  static {
    FieldMetaData.addStructMetaDataMap(Accounting.class, metaDataMap);
  }

  public Accounting() {
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public Accounting(Accounting other) {
    __isset_bit_vector.clear();
    __isset_bit_vector.or(other.__isset_bit_vector);
    this.uploadLimit = other.uploadLimit;
    this.uploadLimitEnd = other.uploadLimitEnd;
    this.uploadLimitNextMonth = other.uploadLimitNextMonth;
    if (other.isSetPremiumServiceStatus()) {
      this.premiumServiceStatus = other.premiumServiceStatus;
    }
    if (other.isSetPremiumOrderNumber()) {
      this.premiumOrderNumber = other.premiumOrderNumber;
    }
    if (other.isSetPremiumCommerceService()) {
      this.premiumCommerceService = other.premiumCommerceService;
    }
    this.premiumServiceStart = other.premiumServiceStart;
    if (other.isSetPremiumServiceSKU()) {
      this.premiumServiceSKU = other.premiumServiceSKU;
    }
    this.lastSuccessfulCharge = other.lastSuccessfulCharge;
    this.lastFailedCharge = other.lastFailedCharge;
    if (other.isSetLastFailedChargeReason()) {
      this.lastFailedChargeReason = other.lastFailedChargeReason;
    }
    this.nextPaymentDue = other.nextPaymentDue;
    this.premiumLockUntil = other.premiumLockUntil;
    this.updated = other.updated;
    if (other.isSetPremiumSubscriptionNumber()) {
      this.premiumSubscriptionNumber = other.premiumSubscriptionNumber;
    }
    this.lastRequestedCharge = other.lastRequestedCharge;
  }

  public Accounting deepCopy() {
    return new Accounting(this);
  }

  @Deprecated
  public Accounting clone() {
    return new Accounting(this);
  }

  public long getUploadLimit() {
    return this.uploadLimit;
  }

  public void setUploadLimit(long uploadLimit) {
    this.uploadLimit = uploadLimit;
    setUploadLimitIsSet(true);
  }

  public void unsetUploadLimit() {
    __isset_bit_vector.clear(__UPLOADLIMIT_ISSET_ID);
  }

  /** Returns true if field uploadLimit is set (has been asigned a value) and false otherwise */
  public boolean isSetUploadLimit() {
    return __isset_bit_vector.get(__UPLOADLIMIT_ISSET_ID);
  }

  public void setUploadLimitIsSet(boolean value) {
    __isset_bit_vector.set(__UPLOADLIMIT_ISSET_ID, value);
  }

  public long getUploadLimitEnd() {
    return this.uploadLimitEnd;
  }

  public void setUploadLimitEnd(long uploadLimitEnd) {
    this.uploadLimitEnd = uploadLimitEnd;
    setUploadLimitEndIsSet(true);
  }

  public void unsetUploadLimitEnd() {
    __isset_bit_vector.clear(__UPLOADLIMITEND_ISSET_ID);
  }

  /** Returns true if field uploadLimitEnd is set (has been asigned a value) and false otherwise */
  public boolean isSetUploadLimitEnd() {
    return __isset_bit_vector.get(__UPLOADLIMITEND_ISSET_ID);
  }

  public void setUploadLimitEndIsSet(boolean value) {
    __isset_bit_vector.set(__UPLOADLIMITEND_ISSET_ID, value);
  }

  public long getUploadLimitNextMonth() {
    return this.uploadLimitNextMonth;
  }

  public void setUploadLimitNextMonth(long uploadLimitNextMonth) {
    this.uploadLimitNextMonth = uploadLimitNextMonth;
    setUploadLimitNextMonthIsSet(true);
  }

  public void unsetUploadLimitNextMonth() {
    __isset_bit_vector.clear(__UPLOADLIMITNEXTMONTH_ISSET_ID);
  }

  /** Returns true if field uploadLimitNextMonth is set (has been asigned a value) and false otherwise */
  public boolean isSetUploadLimitNextMonth() {
    return __isset_bit_vector.get(__UPLOADLIMITNEXTMONTH_ISSET_ID);
  }

  public void setUploadLimitNextMonthIsSet(boolean value) {
    __isset_bit_vector.set(__UPLOADLIMITNEXTMONTH_ISSET_ID, value);
  }

  /**
   * 
   * @see PremiumOrderStatus
   */
  public PremiumOrderStatus getPremiumServiceStatus() {
    return this.premiumServiceStatus;
  }

  /**
   * 
   * @see PremiumOrderStatus
   */
  public void setPremiumServiceStatus(PremiumOrderStatus premiumServiceStatus) {
    this.premiumServiceStatus = premiumServiceStatus;
  }

  public void unsetPremiumServiceStatus() {
    this.premiumServiceStatus = null;
  }

  /** Returns true if field premiumServiceStatus is set (has been asigned a value) and false otherwise */
  public boolean isSetPremiumServiceStatus() {
    return this.premiumServiceStatus != null;
  }

  public void setPremiumServiceStatusIsSet(boolean value) {
    if (!value) {
      this.premiumServiceStatus = null;
    }
  }

  public String getPremiumOrderNumber() {
    return this.premiumOrderNumber;
  }

  public void setPremiumOrderNumber(String premiumOrderNumber) {
    this.premiumOrderNumber = premiumOrderNumber;
  }

  public void unsetPremiumOrderNumber() {
    this.premiumOrderNumber = null;
  }

  /** Returns true if field premiumOrderNumber is set (has been asigned a value) and false otherwise */
  public boolean isSetPremiumOrderNumber() {
    return this.premiumOrderNumber != null;
  }

  public void setPremiumOrderNumberIsSet(boolean value) {
    if (!value) {
      this.premiumOrderNumber = null;
    }
  }

  public String getPremiumCommerceService() {
    return this.premiumCommerceService;
  }

  public void setPremiumCommerceService(String premiumCommerceService) {
    this.premiumCommerceService = premiumCommerceService;
  }

  public void unsetPremiumCommerceService() {
    this.premiumCommerceService = null;
  }

  /** Returns true if field premiumCommerceService is set (has been asigned a value) and false otherwise */
  public boolean isSetPremiumCommerceService() {
    return this.premiumCommerceService != null;
  }

  public void setPremiumCommerceServiceIsSet(boolean value) {
    if (!value) {
      this.premiumCommerceService = null;
    }
  }

  public long getPremiumServiceStart() {
    return this.premiumServiceStart;
  }

  public void setPremiumServiceStart(long premiumServiceStart) {
    this.premiumServiceStart = premiumServiceStart;
    setPremiumServiceStartIsSet(true);
  }

  public void unsetPremiumServiceStart() {
    __isset_bit_vector.clear(__PREMIUMSERVICESTART_ISSET_ID);
  }

  /** Returns true if field premiumServiceStart is set (has been asigned a value) and false otherwise */
  public boolean isSetPremiumServiceStart() {
    return __isset_bit_vector.get(__PREMIUMSERVICESTART_ISSET_ID);
  }

  public void setPremiumServiceStartIsSet(boolean value) {
    __isset_bit_vector.set(__PREMIUMSERVICESTART_ISSET_ID, value);
  }

  public String getPremiumServiceSKU() {
    return this.premiumServiceSKU;
  }

  public void setPremiumServiceSKU(String premiumServiceSKU) {
    this.premiumServiceSKU = premiumServiceSKU;
  }

  public void unsetPremiumServiceSKU() {
    this.premiumServiceSKU = null;
  }

  /** Returns true if field premiumServiceSKU is set (has been asigned a value) and false otherwise */
  public boolean isSetPremiumServiceSKU() {
    return this.premiumServiceSKU != null;
  }

  public void setPremiumServiceSKUIsSet(boolean value) {
    if (!value) {
      this.premiumServiceSKU = null;
    }
  }

  public long getLastSuccessfulCharge() {
    return this.lastSuccessfulCharge;
  }

  public void setLastSuccessfulCharge(long lastSuccessfulCharge) {
    this.lastSuccessfulCharge = lastSuccessfulCharge;
    setLastSuccessfulChargeIsSet(true);
  }

  public void unsetLastSuccessfulCharge() {
    __isset_bit_vector.clear(__LASTSUCCESSFULCHARGE_ISSET_ID);
  }

  /** Returns true if field lastSuccessfulCharge is set (has been asigned a value) and false otherwise */
  public boolean isSetLastSuccessfulCharge() {
    return __isset_bit_vector.get(__LASTSUCCESSFULCHARGE_ISSET_ID);
  }

  public void setLastSuccessfulChargeIsSet(boolean value) {
    __isset_bit_vector.set(__LASTSUCCESSFULCHARGE_ISSET_ID, value);
  }

  public long getLastFailedCharge() {
    return this.lastFailedCharge;
  }

  public void setLastFailedCharge(long lastFailedCharge) {
    this.lastFailedCharge = lastFailedCharge;
    setLastFailedChargeIsSet(true);
  }

  public void unsetLastFailedCharge() {
    __isset_bit_vector.clear(__LASTFAILEDCHARGE_ISSET_ID);
  }

  /** Returns true if field lastFailedCharge is set (has been asigned a value) and false otherwise */
  public boolean isSetLastFailedCharge() {
    return __isset_bit_vector.get(__LASTFAILEDCHARGE_ISSET_ID);
  }

  public void setLastFailedChargeIsSet(boolean value) {
    __isset_bit_vector.set(__LASTFAILEDCHARGE_ISSET_ID, value);
  }

  public String getLastFailedChargeReason() {
    return this.lastFailedChargeReason;
  }

  public void setLastFailedChargeReason(String lastFailedChargeReason) {
    this.lastFailedChargeReason = lastFailedChargeReason;
  }

  public void unsetLastFailedChargeReason() {
    this.lastFailedChargeReason = null;
  }

  /** Returns true if field lastFailedChargeReason is set (has been asigned a value) and false otherwise */
  public boolean isSetLastFailedChargeReason() {
    return this.lastFailedChargeReason != null;
  }

  public void setLastFailedChargeReasonIsSet(boolean value) {
    if (!value) {
      this.lastFailedChargeReason = null;
    }
  }

  public long getNextPaymentDue() {
    return this.nextPaymentDue;
  }

  public void setNextPaymentDue(long nextPaymentDue) {
    this.nextPaymentDue = nextPaymentDue;
    setNextPaymentDueIsSet(true);
  }

  public void unsetNextPaymentDue() {
    __isset_bit_vector.clear(__NEXTPAYMENTDUE_ISSET_ID);
  }

  /** Returns true if field nextPaymentDue is set (has been asigned a value) and false otherwise */
  public boolean isSetNextPaymentDue() {
    return __isset_bit_vector.get(__NEXTPAYMENTDUE_ISSET_ID);
  }

  public void setNextPaymentDueIsSet(boolean value) {
    __isset_bit_vector.set(__NEXTPAYMENTDUE_ISSET_ID, value);
  }

  public long getPremiumLockUntil() {
    return this.premiumLockUntil;
  }

  public void setPremiumLockUntil(long premiumLockUntil) {
    this.premiumLockUntil = premiumLockUntil;
    setPremiumLockUntilIsSet(true);
  }

  public void unsetPremiumLockUntil() {
    __isset_bit_vector.clear(__PREMIUMLOCKUNTIL_ISSET_ID);
  }

  /** Returns true if field premiumLockUntil is set (has been asigned a value) and false otherwise */
  public boolean isSetPremiumLockUntil() {
    return __isset_bit_vector.get(__PREMIUMLOCKUNTIL_ISSET_ID);
  }

  public void setPremiumLockUntilIsSet(boolean value) {
    __isset_bit_vector.set(__PREMIUMLOCKUNTIL_ISSET_ID, value);
  }

  public long getUpdated() {
    return this.updated;
  }

  public void setUpdated(long updated) {
    this.updated = updated;
    setUpdatedIsSet(true);
  }

  public void unsetUpdated() {
    __isset_bit_vector.clear(__UPDATED_ISSET_ID);
  }

  /** Returns true if field updated is set (has been asigned a value) and false otherwise */
  public boolean isSetUpdated() {
    return __isset_bit_vector.get(__UPDATED_ISSET_ID);
  }

  public void setUpdatedIsSet(boolean value) {
    __isset_bit_vector.set(__UPDATED_ISSET_ID, value);
  }

  public String getPremiumSubscriptionNumber() {
    return this.premiumSubscriptionNumber;
  }

  public void setPremiumSubscriptionNumber(String premiumSubscriptionNumber) {
    this.premiumSubscriptionNumber = premiumSubscriptionNumber;
  }

  public void unsetPremiumSubscriptionNumber() {
    this.premiumSubscriptionNumber = null;
  }

  /** Returns true if field premiumSubscriptionNumber is set (has been asigned a value) and false otherwise */
  public boolean isSetPremiumSubscriptionNumber() {
    return this.premiumSubscriptionNumber != null;
  }

  public void setPremiumSubscriptionNumberIsSet(boolean value) {
    if (!value) {
      this.premiumSubscriptionNumber = null;
    }
  }

  public long getLastRequestedCharge() {
    return this.lastRequestedCharge;
  }

  public void setLastRequestedCharge(long lastRequestedCharge) {
    this.lastRequestedCharge = lastRequestedCharge;
    setLastRequestedChargeIsSet(true);
  }

  public void unsetLastRequestedCharge() {
    __isset_bit_vector.clear(__LASTREQUESTEDCHARGE_ISSET_ID);
  }

  /** Returns true if field lastRequestedCharge is set (has been asigned a value) and false otherwise */
  public boolean isSetLastRequestedCharge() {
    return __isset_bit_vector.get(__LASTREQUESTEDCHARGE_ISSET_ID);
  }

  public void setLastRequestedChargeIsSet(boolean value) {
    __isset_bit_vector.set(__LASTREQUESTEDCHARGE_ISSET_ID, value);
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case UPLOAD_LIMIT:
      if (value == null) {
        unsetUploadLimit();
      } else {
        setUploadLimit((Long)value);
      }
      break;

    case UPLOAD_LIMIT_END:
      if (value == null) {
        unsetUploadLimitEnd();
      } else {
        setUploadLimitEnd((Long)value);
      }
      break;

    case UPLOAD_LIMIT_NEXT_MONTH:
      if (value == null) {
        unsetUploadLimitNextMonth();
      } else {
        setUploadLimitNextMonth((Long)value);
      }
      break;

    case PREMIUM_SERVICE_STATUS:
      if (value == null) {
        unsetPremiumServiceStatus();
      } else {
        setPremiumServiceStatus((PremiumOrderStatus)value);
      }
      break;

    case PREMIUM_ORDER_NUMBER:
      if (value == null) {
        unsetPremiumOrderNumber();
      } else {
        setPremiumOrderNumber((String)value);
      }
      break;

    case PREMIUM_COMMERCE_SERVICE:
      if (value == null) {
        unsetPremiumCommerceService();
      } else {
        setPremiumCommerceService((String)value);
      }
      break;

    case PREMIUM_SERVICE_START:
      if (value == null) {
        unsetPremiumServiceStart();
      } else {
        setPremiumServiceStart((Long)value);
      }
      break;

    case PREMIUM_SERVICE_SKU:
      if (value == null) {
        unsetPremiumServiceSKU();
      } else {
        setPremiumServiceSKU((String)value);
      }
      break;

    case LAST_SUCCESSFUL_CHARGE:
      if (value == null) {
        unsetLastSuccessfulCharge();
      } else {
        setLastSuccessfulCharge((Long)value);
      }
      break;

    case LAST_FAILED_CHARGE:
      if (value == null) {
        unsetLastFailedCharge();
      } else {
        setLastFailedCharge((Long)value);
      }
      break;

    case LAST_FAILED_CHARGE_REASON:
      if (value == null) {
        unsetLastFailedChargeReason();
      } else {
        setLastFailedChargeReason((String)value);
      }
      break;

    case NEXT_PAYMENT_DUE:
      if (value == null) {
        unsetNextPaymentDue();
      } else {
        setNextPaymentDue((Long)value);
      }
      break;

    case PREMIUM_LOCK_UNTIL:
      if (value == null) {
        unsetPremiumLockUntil();
      } else {
        setPremiumLockUntil((Long)value);
      }
      break;

    case UPDATED:
      if (value == null) {
        unsetUpdated();
      } else {
        setUpdated((Long)value);
      }
      break;

    case PREMIUM_SUBSCRIPTION_NUMBER:
      if (value == null) {
        unsetPremiumSubscriptionNumber();
      } else {
        setPremiumSubscriptionNumber((String)value);
      }
      break;

    case LAST_REQUESTED_CHARGE:
      if (value == null) {
        unsetLastRequestedCharge();
      } else {
        setLastRequestedCharge((Long)value);
      }
      break;

    }
  }

  public void setFieldValue(int fieldID, Object value) {
    setFieldValue(_Fields.findByThriftIdOrThrow(fieldID), value);
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case UPLOAD_LIMIT:
      return new Long(getUploadLimit());

    case UPLOAD_LIMIT_END:
      return new Long(getUploadLimitEnd());

    case UPLOAD_LIMIT_NEXT_MONTH:
      return new Long(getUploadLimitNextMonth());

    case PREMIUM_SERVICE_STATUS:
      return getPremiumServiceStatus();

    case PREMIUM_ORDER_NUMBER:
      return getPremiumOrderNumber();

    case PREMIUM_COMMERCE_SERVICE:
      return getPremiumCommerceService();

    case PREMIUM_SERVICE_START:
      return new Long(getPremiumServiceStart());

    case PREMIUM_SERVICE_SKU:
      return getPremiumServiceSKU();

    case LAST_SUCCESSFUL_CHARGE:
      return new Long(getLastSuccessfulCharge());

    case LAST_FAILED_CHARGE:
      return new Long(getLastFailedCharge());

    case LAST_FAILED_CHARGE_REASON:
      return getLastFailedChargeReason();

    case NEXT_PAYMENT_DUE:
      return new Long(getNextPaymentDue());

    case PREMIUM_LOCK_UNTIL:
      return new Long(getPremiumLockUntil());

    case UPDATED:
      return new Long(getUpdated());

    case PREMIUM_SUBSCRIPTION_NUMBER:
      return getPremiumSubscriptionNumber();

    case LAST_REQUESTED_CHARGE:
      return new Long(getLastRequestedCharge());

    }
    throw new IllegalStateException();
  }

  public Object getFieldValue(int fieldId) {
    return getFieldValue(_Fields.findByThriftIdOrThrow(fieldId));
  }

  /** Returns true if field corresponding to fieldID is set (has been asigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    switch (field) {
    case UPLOAD_LIMIT:
      return isSetUploadLimit();
    case UPLOAD_LIMIT_END:
      return isSetUploadLimitEnd();
    case UPLOAD_LIMIT_NEXT_MONTH:
      return isSetUploadLimitNextMonth();
    case PREMIUM_SERVICE_STATUS:
      return isSetPremiumServiceStatus();
    case PREMIUM_ORDER_NUMBER:
      return isSetPremiumOrderNumber();
    case PREMIUM_COMMERCE_SERVICE:
      return isSetPremiumCommerceService();
    case PREMIUM_SERVICE_START:
      return isSetPremiumServiceStart();
    case PREMIUM_SERVICE_SKU:
      return isSetPremiumServiceSKU();
    case LAST_SUCCESSFUL_CHARGE:
      return isSetLastSuccessfulCharge();
    case LAST_FAILED_CHARGE:
      return isSetLastFailedCharge();
    case LAST_FAILED_CHARGE_REASON:
      return isSetLastFailedChargeReason();
    case NEXT_PAYMENT_DUE:
      return isSetNextPaymentDue();
    case PREMIUM_LOCK_UNTIL:
      return isSetPremiumLockUntil();
    case UPDATED:
      return isSetUpdated();
    case PREMIUM_SUBSCRIPTION_NUMBER:
      return isSetPremiumSubscriptionNumber();
    case LAST_REQUESTED_CHARGE:
      return isSetLastRequestedCharge();
    }
    throw new IllegalStateException();
  }

  public boolean isSet(int fieldID) {
    return isSet(_Fields.findByThriftIdOrThrow(fieldID));
  }

  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof Accounting)
      return this.equals((Accounting)that);
    return false;
  }

  public boolean equals(Accounting that) {
    if (that == null)
      return false;

    boolean this_present_uploadLimit = true && this.isSetUploadLimit();
    boolean that_present_uploadLimit = true && that.isSetUploadLimit();
    if (this_present_uploadLimit || that_present_uploadLimit) {
      if (!(this_present_uploadLimit && that_present_uploadLimit))
        return false;
      if (this.uploadLimit != that.uploadLimit)
        return false;
    }

    boolean this_present_uploadLimitEnd = true && this.isSetUploadLimitEnd();
    boolean that_present_uploadLimitEnd = true && that.isSetUploadLimitEnd();
    if (this_present_uploadLimitEnd || that_present_uploadLimitEnd) {
      if (!(this_present_uploadLimitEnd && that_present_uploadLimitEnd))
        return false;
      if (this.uploadLimitEnd != that.uploadLimitEnd)
        return false;
    }

    boolean this_present_uploadLimitNextMonth = true && this.isSetUploadLimitNextMonth();
    boolean that_present_uploadLimitNextMonth = true && that.isSetUploadLimitNextMonth();
    if (this_present_uploadLimitNextMonth || that_present_uploadLimitNextMonth) {
      if (!(this_present_uploadLimitNextMonth && that_present_uploadLimitNextMonth))
        return false;
      if (this.uploadLimitNextMonth != that.uploadLimitNextMonth)
        return false;
    }

    boolean this_present_premiumServiceStatus = true && this.isSetPremiumServiceStatus();
    boolean that_present_premiumServiceStatus = true && that.isSetPremiumServiceStatus();
    if (this_present_premiumServiceStatus || that_present_premiumServiceStatus) {
      if (!(this_present_premiumServiceStatus && that_present_premiumServiceStatus))
        return false;
      if (!this.premiumServiceStatus.equals(that.premiumServiceStatus))
        return false;
    }

    boolean this_present_premiumOrderNumber = true && this.isSetPremiumOrderNumber();
    boolean that_present_premiumOrderNumber = true && that.isSetPremiumOrderNumber();
    if (this_present_premiumOrderNumber || that_present_premiumOrderNumber) {
      if (!(this_present_premiumOrderNumber && that_present_premiumOrderNumber))
        return false;
      if (!this.premiumOrderNumber.equals(that.premiumOrderNumber))
        return false;
    }

    boolean this_present_premiumCommerceService = true && this.isSetPremiumCommerceService();
    boolean that_present_premiumCommerceService = true && that.isSetPremiumCommerceService();
    if (this_present_premiumCommerceService || that_present_premiumCommerceService) {
      if (!(this_present_premiumCommerceService && that_present_premiumCommerceService))
        return false;
      if (!this.premiumCommerceService.equals(that.premiumCommerceService))
        return false;
    }

    boolean this_present_premiumServiceStart = true && this.isSetPremiumServiceStart();
    boolean that_present_premiumServiceStart = true && that.isSetPremiumServiceStart();
    if (this_present_premiumServiceStart || that_present_premiumServiceStart) {
      if (!(this_present_premiumServiceStart && that_present_premiumServiceStart))
        return false;
      if (this.premiumServiceStart != that.premiumServiceStart)
        return false;
    }

    boolean this_present_premiumServiceSKU = true && this.isSetPremiumServiceSKU();
    boolean that_present_premiumServiceSKU = true && that.isSetPremiumServiceSKU();
    if (this_present_premiumServiceSKU || that_present_premiumServiceSKU) {
      if (!(this_present_premiumServiceSKU && that_present_premiumServiceSKU))
        return false;
      if (!this.premiumServiceSKU.equals(that.premiumServiceSKU))
        return false;
    }

    boolean this_present_lastSuccessfulCharge = true && this.isSetLastSuccessfulCharge();
    boolean that_present_lastSuccessfulCharge = true && that.isSetLastSuccessfulCharge();
    if (this_present_lastSuccessfulCharge || that_present_lastSuccessfulCharge) {
      if (!(this_present_lastSuccessfulCharge && that_present_lastSuccessfulCharge))
        return false;
      if (this.lastSuccessfulCharge != that.lastSuccessfulCharge)
        return false;
    }

    boolean this_present_lastFailedCharge = true && this.isSetLastFailedCharge();
    boolean that_present_lastFailedCharge = true && that.isSetLastFailedCharge();
    if (this_present_lastFailedCharge || that_present_lastFailedCharge) {
      if (!(this_present_lastFailedCharge && that_present_lastFailedCharge))
        return false;
      if (this.lastFailedCharge != that.lastFailedCharge)
        return false;
    }

    boolean this_present_lastFailedChargeReason = true && this.isSetLastFailedChargeReason();
    boolean that_present_lastFailedChargeReason = true && that.isSetLastFailedChargeReason();
    if (this_present_lastFailedChargeReason || that_present_lastFailedChargeReason) {
      if (!(this_present_lastFailedChargeReason && that_present_lastFailedChargeReason))
        return false;
      if (!this.lastFailedChargeReason.equals(that.lastFailedChargeReason))
        return false;
    }

    boolean this_present_nextPaymentDue = true && this.isSetNextPaymentDue();
    boolean that_present_nextPaymentDue = true && that.isSetNextPaymentDue();
    if (this_present_nextPaymentDue || that_present_nextPaymentDue) {
      if (!(this_present_nextPaymentDue && that_present_nextPaymentDue))
        return false;
      if (this.nextPaymentDue != that.nextPaymentDue)
        return false;
    }

    boolean this_present_premiumLockUntil = true && this.isSetPremiumLockUntil();
    boolean that_present_premiumLockUntil = true && that.isSetPremiumLockUntil();
    if (this_present_premiumLockUntil || that_present_premiumLockUntil) {
      if (!(this_present_premiumLockUntil && that_present_premiumLockUntil))
        return false;
      if (this.premiumLockUntil != that.premiumLockUntil)
        return false;
    }

    boolean this_present_updated = true && this.isSetUpdated();
    boolean that_present_updated = true && that.isSetUpdated();
    if (this_present_updated || that_present_updated) {
      if (!(this_present_updated && that_present_updated))
        return false;
      if (this.updated != that.updated)
        return false;
    }

    boolean this_present_premiumSubscriptionNumber = true && this.isSetPremiumSubscriptionNumber();
    boolean that_present_premiumSubscriptionNumber = true && that.isSetPremiumSubscriptionNumber();
    if (this_present_premiumSubscriptionNumber || that_present_premiumSubscriptionNumber) {
      if (!(this_present_premiumSubscriptionNumber && that_present_premiumSubscriptionNumber))
        return false;
      if (!this.premiumSubscriptionNumber.equals(that.premiumSubscriptionNumber))
        return false;
    }

    boolean this_present_lastRequestedCharge = true && this.isSetLastRequestedCharge();
    boolean that_present_lastRequestedCharge = true && that.isSetLastRequestedCharge();
    if (this_present_lastRequestedCharge || that_present_lastRequestedCharge) {
      if (!(this_present_lastRequestedCharge && that_present_lastRequestedCharge))
        return false;
      if (this.lastRequestedCharge != that.lastRequestedCharge)
        return false;
    }

    return true;
  }

  public int hashCode() {
    return 0;
  }

  public int compareTo(Accounting other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;
    Accounting typedOther = (Accounting)other;

    lastComparison = Boolean.valueOf(isSetUploadLimit()).compareTo(isSetUploadLimit());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(uploadLimit, typedOther.uploadLimit);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetUploadLimitEnd()).compareTo(isSetUploadLimitEnd());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(uploadLimitEnd, typedOther.uploadLimitEnd);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetUploadLimitNextMonth()).compareTo(isSetUploadLimitNextMonth());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(uploadLimitNextMonth, typedOther.uploadLimitNextMonth);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetPremiumServiceStatus()).compareTo(isSetPremiumServiceStatus());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(premiumServiceStatus, typedOther.premiumServiceStatus);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetPremiumOrderNumber()).compareTo(isSetPremiumOrderNumber());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(premiumOrderNumber, typedOther.premiumOrderNumber);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetPremiumCommerceService()).compareTo(isSetPremiumCommerceService());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(premiumCommerceService, typedOther.premiumCommerceService);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetPremiumServiceStart()).compareTo(isSetPremiumServiceStart());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(premiumServiceStart, typedOther.premiumServiceStart);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetPremiumServiceSKU()).compareTo(isSetPremiumServiceSKU());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(premiumServiceSKU, typedOther.premiumServiceSKU);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetLastSuccessfulCharge()).compareTo(isSetLastSuccessfulCharge());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(lastSuccessfulCharge, typedOther.lastSuccessfulCharge);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetLastFailedCharge()).compareTo(isSetLastFailedCharge());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(lastFailedCharge, typedOther.lastFailedCharge);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetLastFailedChargeReason()).compareTo(isSetLastFailedChargeReason());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(lastFailedChargeReason, typedOther.lastFailedChargeReason);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetNextPaymentDue()).compareTo(isSetNextPaymentDue());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(nextPaymentDue, typedOther.nextPaymentDue);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetPremiumLockUntil()).compareTo(isSetPremiumLockUntil());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(premiumLockUntil, typedOther.premiumLockUntil);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetUpdated()).compareTo(isSetUpdated());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(updated, typedOther.updated);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetPremiumSubscriptionNumber()).compareTo(isSetPremiumSubscriptionNumber());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(premiumSubscriptionNumber, typedOther.premiumSubscriptionNumber);
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = Boolean.valueOf(isSetLastRequestedCharge()).compareTo(isSetLastRequestedCharge());
    if (lastComparison != 0) {
      return lastComparison;
    }
    lastComparison = TBaseHelper.compareTo(lastRequestedCharge, typedOther.lastRequestedCharge);
    if (lastComparison != 0) {
      return lastComparison;
    }
    return 0;
  }

  public void read(TProtocol iprot) throws TException {
    TField field;
    iprot.readStructBegin();
    while (true)
    {
      field = iprot.readFieldBegin();
      if (field.type == TType.STOP) { 
        break;
      }
      _Fields fieldId = _Fields.findByThriftId(field.id);
      if (fieldId == null) {
        TProtocolUtil.skip(iprot, field.type);
      } else {
        switch (fieldId) {
          case UPLOAD_LIMIT:
            if (field.type == TType.I64) {
              this.uploadLimit = iprot.readI64();
              setUploadLimitIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case UPLOAD_LIMIT_END:
            if (field.type == TType.I64) {
              this.uploadLimitEnd = iprot.readI64();
              setUploadLimitEndIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case UPLOAD_LIMIT_NEXT_MONTH:
            if (field.type == TType.I64) {
              this.uploadLimitNextMonth = iprot.readI64();
              setUploadLimitNextMonthIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case PREMIUM_SERVICE_STATUS:
            if (field.type == TType.I32) {
              this.premiumServiceStatus = PremiumOrderStatus.findByValue(iprot.readI32());
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case PREMIUM_ORDER_NUMBER:
            if (field.type == TType.STRING) {
              this.premiumOrderNumber = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case PREMIUM_COMMERCE_SERVICE:
            if (field.type == TType.STRING) {
              this.premiumCommerceService = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case PREMIUM_SERVICE_START:
            if (field.type == TType.I64) {
              this.premiumServiceStart = iprot.readI64();
              setPremiumServiceStartIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case PREMIUM_SERVICE_SKU:
            if (field.type == TType.STRING) {
              this.premiumServiceSKU = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case LAST_SUCCESSFUL_CHARGE:
            if (field.type == TType.I64) {
              this.lastSuccessfulCharge = iprot.readI64();
              setLastSuccessfulChargeIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case LAST_FAILED_CHARGE:
            if (field.type == TType.I64) {
              this.lastFailedCharge = iprot.readI64();
              setLastFailedChargeIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case LAST_FAILED_CHARGE_REASON:
            if (field.type == TType.STRING) {
              this.lastFailedChargeReason = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case NEXT_PAYMENT_DUE:
            if (field.type == TType.I64) {
              this.nextPaymentDue = iprot.readI64();
              setNextPaymentDueIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case PREMIUM_LOCK_UNTIL:
            if (field.type == TType.I64) {
              this.premiumLockUntil = iprot.readI64();
              setPremiumLockUntilIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case UPDATED:
            if (field.type == TType.I64) {
              this.updated = iprot.readI64();
              setUpdatedIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case PREMIUM_SUBSCRIPTION_NUMBER:
            if (field.type == TType.STRING) {
              this.premiumSubscriptionNumber = iprot.readString();
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case LAST_REQUESTED_CHARGE:
            if (field.type == TType.I64) {
              this.lastRequestedCharge = iprot.readI64();
              setLastRequestedChargeIsSet(true);
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
        }
        iprot.readFieldEnd();
      }
    }
    iprot.readStructEnd();
    validate();
  }

  public void write(TProtocol oprot) throws TException {
    validate();

    oprot.writeStructBegin(STRUCT_DESC);
    if (isSetUploadLimit()) {
      oprot.writeFieldBegin(UPLOAD_LIMIT_FIELD_DESC);
      oprot.writeI64(this.uploadLimit);
      oprot.writeFieldEnd();
    }
    if (isSetUploadLimitEnd()) {
      oprot.writeFieldBegin(UPLOAD_LIMIT_END_FIELD_DESC);
      oprot.writeI64(this.uploadLimitEnd);
      oprot.writeFieldEnd();
    }
    if (isSetUploadLimitNextMonth()) {
      oprot.writeFieldBegin(UPLOAD_LIMIT_NEXT_MONTH_FIELD_DESC);
      oprot.writeI64(this.uploadLimitNextMonth);
      oprot.writeFieldEnd();
    }
    if (this.premiumServiceStatus != null) {
      if (isSetPremiumServiceStatus()) {
        oprot.writeFieldBegin(PREMIUM_SERVICE_STATUS_FIELD_DESC);
        oprot.writeI32(this.premiumServiceStatus.getValue());
        oprot.writeFieldEnd();
      }
    }
    if (this.premiumOrderNumber != null) {
      if (isSetPremiumOrderNumber()) {
        oprot.writeFieldBegin(PREMIUM_ORDER_NUMBER_FIELD_DESC);
        oprot.writeString(this.premiumOrderNumber);
        oprot.writeFieldEnd();
      }
    }
    if (this.premiumCommerceService != null) {
      if (isSetPremiumCommerceService()) {
        oprot.writeFieldBegin(PREMIUM_COMMERCE_SERVICE_FIELD_DESC);
        oprot.writeString(this.premiumCommerceService);
        oprot.writeFieldEnd();
      }
    }
    if (isSetPremiumServiceStart()) {
      oprot.writeFieldBegin(PREMIUM_SERVICE_START_FIELD_DESC);
      oprot.writeI64(this.premiumServiceStart);
      oprot.writeFieldEnd();
    }
    if (this.premiumServiceSKU != null) {
      if (isSetPremiumServiceSKU()) {
        oprot.writeFieldBegin(PREMIUM_SERVICE_SKU_FIELD_DESC);
        oprot.writeString(this.premiumServiceSKU);
        oprot.writeFieldEnd();
      }
    }
    if (isSetLastSuccessfulCharge()) {
      oprot.writeFieldBegin(LAST_SUCCESSFUL_CHARGE_FIELD_DESC);
      oprot.writeI64(this.lastSuccessfulCharge);
      oprot.writeFieldEnd();
    }
    if (isSetLastFailedCharge()) {
      oprot.writeFieldBegin(LAST_FAILED_CHARGE_FIELD_DESC);
      oprot.writeI64(this.lastFailedCharge);
      oprot.writeFieldEnd();
    }
    if (this.lastFailedChargeReason != null) {
      if (isSetLastFailedChargeReason()) {
        oprot.writeFieldBegin(LAST_FAILED_CHARGE_REASON_FIELD_DESC);
        oprot.writeString(this.lastFailedChargeReason);
        oprot.writeFieldEnd();
      }
    }
    if (isSetNextPaymentDue()) {
      oprot.writeFieldBegin(NEXT_PAYMENT_DUE_FIELD_DESC);
      oprot.writeI64(this.nextPaymentDue);
      oprot.writeFieldEnd();
    }
    if (isSetPremiumLockUntil()) {
      oprot.writeFieldBegin(PREMIUM_LOCK_UNTIL_FIELD_DESC);
      oprot.writeI64(this.premiumLockUntil);
      oprot.writeFieldEnd();
    }
    if (isSetUpdated()) {
      oprot.writeFieldBegin(UPDATED_FIELD_DESC);
      oprot.writeI64(this.updated);
      oprot.writeFieldEnd();
    }
    if (this.premiumSubscriptionNumber != null) {
      if (isSetPremiumSubscriptionNumber()) {
        oprot.writeFieldBegin(PREMIUM_SUBSCRIPTION_NUMBER_FIELD_DESC);
        oprot.writeString(this.premiumSubscriptionNumber);
        oprot.writeFieldEnd();
      }
    }
    if (isSetLastRequestedCharge()) {
      oprot.writeFieldBegin(LAST_REQUESTED_CHARGE_FIELD_DESC);
      oprot.writeI64(this.lastRequestedCharge);
      oprot.writeFieldEnd();
    }
    oprot.writeFieldStop();
    oprot.writeStructEnd();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder("Accounting(");
    boolean first = true;

    if (isSetUploadLimit()) {
      sb.append("uploadLimit:");
      sb.append(this.uploadLimit);
      first = false;
    }
    if (isSetUploadLimitEnd()) {
      if (!first) sb.append(", ");
      sb.append("uploadLimitEnd:");
      sb.append(this.uploadLimitEnd);
      first = false;
    }
    if (isSetUploadLimitNextMonth()) {
      if (!first) sb.append(", ");
      sb.append("uploadLimitNextMonth:");
      sb.append(this.uploadLimitNextMonth);
      first = false;
    }
    if (isSetPremiumServiceStatus()) {
      if (!first) sb.append(", ");
      sb.append("premiumServiceStatus:");
      if (this.premiumServiceStatus == null) {
        sb.append("null");
      } else {
        String premiumServiceStatus_name = premiumServiceStatus.name();
        if (premiumServiceStatus_name != null) {
          sb.append(premiumServiceStatus_name);
          sb.append(" (");
        }
        sb.append(this.premiumServiceStatus);
        if (premiumServiceStatus_name != null) {
          sb.append(")");
        }
      }
      first = false;
    }
    if (isSetPremiumOrderNumber()) {
      if (!first) sb.append(", ");
      sb.append("premiumOrderNumber:");
      if (this.premiumOrderNumber == null) {
        sb.append("null");
      } else {
        sb.append(this.premiumOrderNumber);
      }
      first = false;
    }
    if (isSetPremiumCommerceService()) {
      if (!first) sb.append(", ");
      sb.append("premiumCommerceService:");
      if (this.premiumCommerceService == null) {
        sb.append("null");
      } else {
        sb.append(this.premiumCommerceService);
      }
      first = false;
    }
    if (isSetPremiumServiceStart()) {
      if (!first) sb.append(", ");
      sb.append("premiumServiceStart:");
      sb.append(this.premiumServiceStart);
      first = false;
    }
    if (isSetPremiumServiceSKU()) {
      if (!first) sb.append(", ");
      sb.append("premiumServiceSKU:");
      if (this.premiumServiceSKU == null) {
        sb.append("null");
      } else {
        sb.append(this.premiumServiceSKU);
      }
      first = false;
    }
    if (isSetLastSuccessfulCharge()) {
      if (!first) sb.append(", ");
      sb.append("lastSuccessfulCharge:");
      sb.append(this.lastSuccessfulCharge);
      first = false;
    }
    if (isSetLastFailedCharge()) {
      if (!first) sb.append(", ");
      sb.append("lastFailedCharge:");
      sb.append(this.lastFailedCharge);
      first = false;
    }
    if (isSetLastFailedChargeReason()) {
      if (!first) sb.append(", ");
      sb.append("lastFailedChargeReason:");
      if (this.lastFailedChargeReason == null) {
        sb.append("null");
      } else {
        sb.append(this.lastFailedChargeReason);
      }
      first = false;
    }
    if (isSetNextPaymentDue()) {
      if (!first) sb.append(", ");
      sb.append("nextPaymentDue:");
      sb.append(this.nextPaymentDue);
      first = false;
    }
    if (isSetPremiumLockUntil()) {
      if (!first) sb.append(", ");
      sb.append("premiumLockUntil:");
      sb.append(this.premiumLockUntil);
      first = false;
    }
    if (isSetUpdated()) {
      if (!first) sb.append(", ");
      sb.append("updated:");
      sb.append(this.updated);
      first = false;
    }
    if (isSetPremiumSubscriptionNumber()) {
      if (!first) sb.append(", ");
      sb.append("premiumSubscriptionNumber:");
      if (this.premiumSubscriptionNumber == null) {
        sb.append("null");
      } else {
        sb.append(this.premiumSubscriptionNumber);
      }
      first = false;
    }
    if (isSetLastRequestedCharge()) {
      if (!first) sb.append(", ");
      sb.append("lastRequestedCharge:");
      sb.append(this.lastRequestedCharge);
      first = false;
    }
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws TException {
    // check for required fields
  }

}

