<?php
/**
@file
@brief ǼĤα
@version $Id: MessageFilter.php,v 1.5 2004/07/28 04:31:11 minahito Exp $
*/

require_once "exForm/Filter.php";

/**
@brief BBS ޤǥåľᤫե륿֥å̤ǻѡ
*/
class MessagePostFilter extends exAbstractFilterForm {

	function getCriteria($start=0,$limit=0)
	{
		$criteria = new CriteriaCompo();

		$criteria->setSort('inputdate');
		$criteria->setOrder('DESC');
		$criteria->setStart($start);
		$criteria->setLimit($limit);

		return ($criteria);
	}

	function getTotal()
	{
		$handler=&YYBBS::getHandler('message');
		return $handler->getCount($this->getCriteria());
	}
}

/**
@brief åɿƥåΤߤ뤿Υե륿BBS_ID ˤб
@note bbs_id ꥯȤǤʤƤ⥨顼ˤϤʤޤΤǡȥ¦Ǹ
*/
class MessageThreadFilter extends MessagePostFilter {
	var $bbs_id_=null;
	
	function fetch()
	{
		$this->bbs_id_=$this->getPositiveIntger('bbs_id');
	}

	function getCriteria($start=0,$limit=0)
	{
		$criteria = parent::getCriteria($start,$limit);

		if($this->bbs_id_)
			$criteria->add(new Criteria('bbs_id',$this->bbs_id_));

		$criteria->add(new Criteria('parent',0));
		$criteria->setSort('update_date');

		return $criteria;
	}

	function getExtra()
	{
		return array("bbs_id"=>$this->bbs_id_);
	}
}

/**
@brief ID ƣåɤ Criteria ֤ե륿
*/
class MessageOneThreadIDFilter extends MessagePostFilter {
	var $id_=null;
	var $bbs_id_=null;
	
	function fetch()
	{
		$this->id_=$this->getPositiveIntger('id');
		if($this->id_) {
			// BBS_ID Ĵ٤ʥꥯȤϥƤˤʤ
			// ǥɤΤġĤȤ⤹뤬;;
			$handler=&YYBBS::getHandler('message');
			$message=&$handler->get($this->id_);
			$this->bbs_id_=$message->getVar('bbs_id');
		}
		else
			$this->msg_[] = "REQUEST_ERROR";
	}

	function getCriteria($start=0,$limit=0)
	{
		$criteria = parent::getCriteria($start,$limit);
		$criteria->add(new Criteria('id',$this->id_));
		$criteria->add(new Criteria('parent',0));
		$criteria->setSort('update_date');

		return $criteria;
	}

	function getExtra()
	{
		return array("id"=>$this->id_,
				"bbs_id"=>$this->bbs_id_);
	}
}

/**
@brief BBS ID  Serial 飱åɤ Criteria ֤ե륿
*/
class MessageOneThreadSerialFilter extends MessagePostFilter {
	var $serial_=null;
	var $bbs_id_=null;
	
	function fetch()
	{
		$this->serial_=$this->getPositiveIntger('serial');
		$this->bbs_id_=$this->getPositiveIntger('bbs_id');
		if(!$this->serial_ or !$this->bbs_id_)
			$this->msg_[]="REQUEST ERROR"; 
	}

	function getCriteria($start=0,$limit=0)
	{
		$criteria = parent::getCriteria($start,$limit);

		$criteria->add(new Criteria('serial',$this->serial_));
		$criteria->add(new Criteria('bbs_id',$this->bbs_id_));

		$criteria->add(new Criteria('parent',0));
		$criteria->setSort('update_date');

		return $criteria;
	}

	function getExtra()
	{
		return array("id"=>$this->serial_,
				"bbs_id"=>$this->bbs_id_);
	}
}

?>
