<?php
/**
@file
@brief Party ѥե
*/

require_once "exForm/Form.php";
require_once "exComponent/Input.php";
require_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";

class PartyForm extends exAbstractActionForm {

	function doGet($data) {
		global $xoopsUser;

		$handler = bxParty::getHandler('party');
		if(isset($_REQUEST['id'])) {
			$id=intval($_REQUEST['id']);
			if($id>0)
				$this->data_=&$handler->get($id);
		}

		if(!$this->data_)
			$this->data_=&$handler->create();
		else {	// Խ¤Υå
			if(!$xoopsUser->isAdmin() and $this->data_->getVar('uid')!=$xoopsUser->uid()) {
				$this->msg_[]="Խ¤ޤ";
				$this->data_=&$handler->create();
			}
		}
	}
	
	function doPost($data) {
		global $xoopsUser;

		// ɤλ
		$this->doGet($data);

		if(!is_object($xoopsUser)) {
			$this->msg_[]='Ͽ桼ǤʤƤǤޤ';
		}
		else {
			// Ϥʤ uid Ͽ
			if(!$this->data_->getVar('id'))
				$this->data_->setVar('uid',$xoopsUser->uid());
		}

		$private=intval($_POST['private']);
		if(!$this->validateInRange($private,0,1)) {
			$this->msg_[]='private ͤϰϤĶƤޤ';
		}
		$this->data_->setVar('private',$private);

		if(!$this->data_->getVar('input_date'))
			$this->data_->setVar('input_date',time());

		$this->data_->setVar('update_date',time());

		$event_date=exFrame::decodeXoopsFormDateTime($_POST['event_date']);
		if(!$event_date) {
			$this->msg_[]='٥ȳͤǤ';
		}
		$this->data_->setVar('event_date',$event_date);

		$limit_date=exFrame::decodeXoopsFormDateTime($_POST['limit_date']);
		if(!$limit_date) {
			$this->msg_[]='ȥ꡼մͤǤ';
		}
		$this->data_->setVar('limit_date',$limit_date);

		$this->data_->setVar('title',trim($_POST['title']));
		$headline=trim($_POST['headline']);
		
		if(!$this->validateMaxLength($headline,255)) {
			$this->msg_[]="إåɥ饤 255 ʸˤƤ";
		}
		$this->data_->setVar('headline',trim($_POST['headline']));

		// ơå(Ūͳ 0 ޤ)
		$status=$this->getPositive($_POST['status']);
		if($status) {
			$handler=&bxParty::getHandler('status');
			$tmp=$handler->get($status);
			if(!is_object($tmp)) {
				$this->msg_[]="ơǤ";
			}
			else {	// ѤɤơɤĴ٤
				if(!($tmp->getVar('status')==_BXPARTY_STATUS_BOTH || $tmp->getVar('status')==_BXPARTY_STATUS_PARTY)) {
					$this->msg_[]="ơǤ";
				}
			}
		}
		$this->data_->setVar('status',$status);

		$url=trim($_POST['url']);
		if(strlen($url)) {
			if(strpos($url,"http://")!==0 and strpos($url,"https://")!==0)
				$this->msg_[]="URL Ǥ";
		}
		$this->data_->setVar('url',trim($_POST['url']));
		$this->data_->setVar('ex',trim($_POST['ex']));
		$this->data_->setVar('place',trim($_POST['place']));

		if(!$this->data_->cleanVars()) {
			$this->msg_=array_merge($this->msg_,$this->data_->getErrors());
		}
	}
}

class PartyInputComponentRender extends exInputComponentRender {
	function render() {
		$handler=bxParty::getHandler('status');
		$criteria=new CriteriaCompo();
		$criteria->add(new Criteria("type",_BXPARTY_STATUS_BOTH));
		$criteria->add(new Criteria("type",_BXPARTY_STATUS_PARTY),"OR");
		$objs=&$handler->getObjects($criteria,null,'priority');

		$form = new XoopsThemeForm('Party','party',$_SERVER['SCRIPT_NAME'],'POST');

		$form->addElement(new XoopsFormHidden('id',$this->component_->form_->data_->getVar('id')));
		$form->addElement(new XoopsFormText(_MD_BXPARTY_LANG_TITLE,'title',64,64,$this->component_->form_->data_->getVar('title')));
		$form->addElement(new XoopsFormTextArea(_MD_BXPARTY_LANG_HEADLINE,'headline',$this->component_->form_->data_->getVar('headline','e'),3,50));
		$form->addElement(new XoopsFormDhtmlTextArea(_MD_BXPARTY_LANG_EX,'ex',$this->component_->form_->data_->getVar('ex','e'),8));
		$form->addElement(new XoopsFormText(_MD_BXPARTY_LANG_PLACE,'place',64,255,$this->component_->form_->data_->getVar('place')));
		$form->addElement(new XoopsFormText(_MD_BXPARTY_LANG_URL,'url',64,64,$this->component_->form_->data_->getVar('url')));

		$sel = new XoopsFormSelect(_MD_BXPARTY_LANG_PUBLIC_FLAG,'private',$this->component_->form_->data_->getVar('private'));
		$sel->addOption(0,_MD_BXPARTY_LANG_PUBLIC_SET);
		$sel->addOption(1,_MD_BXPARTY_LANG_PRIVATE_SET);
		$form->addElement($sel);

		$sel2 = new XoopsFormSelect(_MD_BXPARTY_LANG_STATUS,'status',$this->component_->form_->data_->getVar('status'));
		foreach($objs as $obj) {
			$sel2->addOption($obj->getVar('id'),$obj->getVar('name'));
		}
		$form->addElement($sel2);

		$form->addElement(new XoopsFormDateTime(_MD_BXPARTY_LANG_EVENT_DATE,'event_date',15,$this->component_->form_->data_->getVar('event_date')));
		$form->addElement(new XoopsFormDateTime(_MD_BXPARTY_LANG_LIMIT_DATE,'limit_date',15,$this->component_->form_->data_->getVar('limit_date')));
		$form->addElement(new XoopsFormButton('SAVE',"submit","submit","submit"));

		$form->display();
	}
}

?>