fcf.module({
  name: "fcf:NFSQL/NDetails/AutomateLanguageItem.js",
  dependencies: [],
  module: function(){
    var Automate = fcf.prepareObject(fcf, "NFSQL.NDetails.Automate");

    Automate.LanguageItem_Start = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "^{s}";
      this.map["language"] = { factory: "LanguageItem_SkipSpaces", skipFirst: false};
    }

    Automate.LanguageItem_SkipSpaces = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: "LanguageItem_ReadLang", skipFirst: false};
      this.map["$"]     = { factory: "StepSingleValue", exit: "LanguageItem_PostValue", dstValue: "language", skipFirst: false, path: "language"};
    }

    Automate.LanguageItem_PostValue = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map[""]   = { factory: "LanguageItem_PrePostSpaces", skipFirst: false};
      this.actionSwitch   = function() {
        a_state.language  = a_state.language.value;
      }
    }

    Automate.LanguageItem_ReadLang = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{nm}"]   = null;
      this.map[""]        = { factory: "LanguageItem_PrePostSpaces", skipFirst: false};
      this.actionSwitch   = function() {
        a_state.language  = this.buffer;
      }
    }

    Automate.LanguageItem_PrePostSpaces = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
      this.map["^{nm}"] = { factory: "LanguageItem_ReadDefaultLanguage", skipFirst: false};
    }

    Automate.LanguageItem_ReadDefaultLanguage = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "^{s}";
      this.map["default"] = { factory: "LanguageItem_PostSpaces", skipFirst: true};
      this.actionSwitch   = function() {
        a_state.defaultLanguage = true;
      }
    }

    Automate.LanguageItem_PostSpaces = function(a_state) {
      Automate.BaseStep.call(this, a_state);
      this.delimeter = "";
      this.map["^{s}"] = null;
    }

    return Automate;

  }
});
