fcf.module({
  name: "fcfControls:templates/checkbox.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      getActionDomElement() {
        return fcf.select(this.getDomElement(), "span")[0];
      }

      onClick(a_event){
        if (!this.getArg("enable"))
          return;
        this.setArg("value", !this.getArg("value"));
        this._setState();
      }

      fcfEventKeyDown(a_event){
        if (a_event.keyCode==32 || a_event.keyCode==13)
          this.onClick(a_event);
      }

      _setState() {
        if (this.getArg("value"))
          this.getActionDomElement().setAttribute("checked", "checked");
        else 
          this.getActionDomElement().removeAttribute("checked");
        if (this.getArg("enable"))
          this.getActionDomElement().removeAttribute("readonly");
        else 
          this.getActionDomElement().setAttribute("readonly");
      }

    };
  }
});
