fcf.module({
  name: "fcfControls:templates/modal-dialog.wrapper.js",
  dependencies: ["fcf:NClient/Wrapper.js"],
  module: function(Wrapper){
    return class ModalDialog extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
        this._locker = undefined;
        this._mouseStartDDPos = undefined;
      }

      attach() {
        let self = this;
        let position = this.getArg("position");
        let element = this.getDomElement();
        let modal = this.getArg("modal");

        let okButton = this.getChild("ok");
        if (okButton) {
          fcf.addDomListener(okButton.getDomElement(), "click", function(a_event) {
            a_event.preventDefault();
            self.destroy();
          });
        }

        fcf.addDomListener(fcf.select(this.getDomElement(), ".fcf-dialog-title")[0], "mousedown", function(a_event) {
          self.onTitleMouseDown(a_event);
        });
        fcf.addDomListener(fcf.select(this.getDomElement(), ".fcf-dialog-title")[0], "mouseup", function(a_event) {
          self.onTitleMouseUp(a_event);
        });
        fcf.addDomListener(document.body, "mousemove", function(a_event) {
          self.onTitleMouseMove(a_event);
        });

        if (position == "center")
          this._setCenterPosition();

        if (modal){
          element.style.zIndex = 1000;
          fcf.locker({
            content:  "",
            selector: "body",
            onResult: function(a_error, a_template) {
              self._locker = a_template.wrapper;
            }
          });
        }

        super.attach();
      }

      

      onTitleMouseDown(a_event){
        a_event.preventDefault();
        if (a_event.buttons != 1 || this._mouseStartDDPos)
          return;
        this._mouseStartDDPos = {x: a_event.screenX, y: a_event.screenY};
      }

      onTitleMouseUp(a_event){
        if (a_event.buttons != 0 || !this._mouseStartDDPos)
          return;
        var element = this.getDomElement();
        var offsetX = a_event.screenX - this._mouseStartDDPos.x;
        var offsetY = a_event.screenY - this._mouseStartDDPos.y;
        var left = parseInt(element.getAttribute("left")) + offsetX;
        var top  = parseInt(element.getAttribute("top")) + offsetY;
        element.setAttribute("left", left);
        element.setAttribute("top", top);

        this._mouseStartDDPos = undefined;
      }

      onTitleMouseMove(a_event){
        if (!this._mouseStartDDPos)
          return;
        var element = this.getDomElement();
        var offsetX = a_event.screenX - this._mouseStartDDPos.x;
        var offsetY = a_event.screenY - this._mouseStartDDPos.y;
        var left = parseInt(element.getAttribute("left")) + offsetX;
        var top  = parseInt(element.getAttribute("top")) + offsetY;
        element.style.left = left + "px";
        element.style.top  = top + "px";
      }

      var originDestroy = this.destroy;
      this.destroy = function(){
        if (this._locker)
          this._locker.destroy();

        originDestroy.call(this);
      }

      getBodyDomElement(){
        return fcf.select(this.getDomElement(), "[name=body]")[0];
      }

      _setCenterPosition(){
        var element = this.getDomElement();
        var selfRect = element.getBoundingClientRect();

        var screenTop    = document.body.scrollTop;
        var screenHeight = window.innerHeight;
        var screenLeft   = document.body.scrollLeft;
        var screenWidth  = window.innerWidth;
        var screenOffsetTop  = screenTop + screenHeight / 2;
        var screenOffsetLeft = screenLeft + screenWidth / 2;
        var selfOffsetLeft = selfRect.width/2;
        var selfOffsetTop  = selfRect.height/2;

        element.style.position = "absolute";
        var left = Math.floor(screenOffsetLeft - selfOffsetLeft);
        var top = Math.floor(screenOffsetTop - selfOffsetTop);
        element.style.left = left + "px";
        element.style.top  = top + "px";
        element.setAttribute("left", left);
        element.setAttribute("top", top);
      }

    };
  }
});
