<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.RDF
 */
/**
 * @file Triple.php
 * @brief Triple.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: Triple.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
/**
 * @class Ficus_Triple
 */
interface Ficus_Triple
{
    /**
     * set subject node.
     *
     * @param $subject string subject.
     */
    public function setSubject($subject);

    /**
     * get subject node.
     *
     * @return string subject.
     */
    public function subject();

    /**
     * set predicate node.
     *
     * @param $predicate string predicate.
     */
    public function setPredicate($predicate);

    /**
     * get predicate node.
     *
     * @return string predicate.
     */
    public function predicate();

    /**
     * set object node.
     *
     * @param $object string object.
     */
    public function setObject($object);

    /**
     * get object node.
     *
     * @return string object.
     */
    public function object();

    /**
     * compare.
     *
     * @param $triple Triple another triple.
     */
    public function compare($triple);

    /**
     * equals.
     *
     * @param $triple Triple another triple.
     * @see Ficus_Node
     */
    public function equals($triple);

    /**
     * match nodes.
     *
     * @param $subject Ficus_Node subject node
     * @param $predicate Ficus_Node predicate node
     * @param $object Ficus_Node object node
     * @return boolean true if match.
     */
    //public function match($subject, $predicate, $object);
}
?>
