<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans
 */
/**
 * @file BeanComponentFactory.php
 * @brief BeanComponentFactory.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: BeanComponentFactory.php 48 2007-09-20 07:21:07Z ishitoya $
 *
 */
require_once "ficus/lang/AutoLoad.php";
require_once "ficus/lang/S2ContainerAutoLoad.php";
require_once "ficus/lang/ClassLoaderAutoLoad.php";
require_once "ficus/lang/ClassPath.php";
require_once "ficus/test/PathInitializer.php";
require_once "ficus/di/S2ContainerComponentFactory.php";

/**
 * @class Ficus_BeanComponentFactory
 */
class Ficus_BeanComponentFactory extends Ficus_S2ContainerComponentFactory
{    
    const CONTEXT_BUILD = "mock";
    const CONTEXT_DEPLOY = "deploy";
    
    /**
     * @var $context string context
     */
    private static $context = Ficus_BeanComponentFactory::CONTEXT_DEPLOY;

    /**
     * dicon file name registry key
     */
    const REGISTRY_DICON_FILENAME = "beans.dicon";

    /**
     * dicon namespace registry key
     */
    const REGISTRY_DICON_NAMESPACE = "beans.namespace";
    
    /**
     * Default dicon file name.
     */
    const DEFAULT_DICON_FILENAME = 'beans.dicon';

    /**
     * dicon namespace.
     */
    const DEFAULT_DICON_NAMESPACE = 'beans.scheme';
    
    /**
     * get Dicon file name from registry
     * @return string dicon filename
     */
    protected function getDiconFileNameRegistry(){
        return self::REGISTRY_DICON_FILENAME;
    }

    /**
     * get Dicon namespace from registry
     * @return string dicon namespace
     */
    protected function getDiconNameSpaceRegistry(){
        return self::REGISTRY_DICON_NAMESPACE;
    }

    /**
     * get dicon file name
     * @return string dicon file name
     */
    protected function getDefaultDiconFileName(){
        return Ficus_File::currentDir()
            ->resolve(self::DEFAULT_DICON_FILENAME)->getPath();
    }
    
    /**
     * get defoult dicon namespace
     * @return string dicon namespace
     */
    protected function getDefaultDiconNameSpace(){
        return self::DEFAULT_DICON_NAMESPACE;
    }

    /**
     * get component
     * @param $name string name of component
     * @param $class string class name
     * @return Ficus_ScaffoldComponentFactory
     */
    public static function getComponent($name, $class = __CLASS__){
        return parent::getComponent($name, $class);
    }

    /**
     * set context and reset factory
     *
     * @param $context string build or deploy
     */
    public static function setContext($context){
        if(self::$context !== $context){
            self::$context = $context;
            self::$factory = null;
        }
    }
}
?>
